/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.shader.forward;

import org.achtern.AchternEngine.core.Transform;
import org.achtern.AchternEngine.core.Window;
import org.achtern.AchternEngine.core.math.Matrix4f;
import org.achtern.AchternEngine.core.rendering.Material;
import org.achtern.AchternEngine.core.rendering.RenderEngine;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.resource.ResourceLoader;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.Uniform;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.WireframeDisplay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wireframe
extends Shader {
    public static final Logger LOGGER = LoggerFactory.getLogger(Wireframe.class);
    private static final Wireframe instance = new Wireframe();

    public static Wireframe getInstance() {
        return instance;
    }

    private Wireframe() {
        try {
            this.program = ResourceLoader.getShaderProgram("debug.wireframe");
        }
        catch (Exception e) {
            LOGGER.warn("Error Loading Bundled Debug Wireframe Shader GLSL files.", (Throwable)e);
        }
    }

    protected void handle(Uniform uniform, Transform transform, Material material, RenderEngine renderEngine, Matrix4f projection) {
        if (uniform.getName().equalsIgnoreCase("WIN_SCALE")) {
            uniform.setValue(Window.get());
        }
        if (uniform.getName().equalsIgnoreCase("wirecolor")) {
            uniform.setValue(((WireframeDisplay)renderEngine.getActiveRenderPass()).getWirecolor());
        }
        if (uniform.getName().equalsIgnoreCase("fillcolor")) {
            uniform.setValue(((WireframeDisplay)renderEngine.getActiveRenderPass()).getFillcolor());
        }
    }
}

