/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.texture;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.achtern.AchternEngine.core.bootstrap.Native;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.texture.Filter;
import org.achtern.AchternEngine.core.rendering.texture.Format;
import org.achtern.AchternEngine.core.rendering.texture.InternalFormat;
import org.achtern.AchternEngine.core.rendering.texture.TexturableData;
import org.achtern.AchternEngine.core.rendering.texture.Type;
import org.achtern.AchternEngine.core.resource.ResourceConverter;
import org.achtern.AchternEngine.core.util.UBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Texture
extends Dimension
implements TexturableData,
Native {
    public static final Logger LOGGER = LoggerFactory.getLogger(Texture.class);
    protected int id = -1;
    protected Type type;
    protected Filter minFilter;
    protected Filter magFilter;
    protected InternalFormat internalFormat;
    protected Format format;
    protected boolean alpha;
    protected ByteBuffer data;

    public Texture(Dimension dimension, Type type, Filter minFilter, Filter magFilter, InternalFormat internalFormat, Format format, boolean alpha, ByteBuffer data) {
        super(dimension);
        this.type = type;
        this.minFilter = minFilter;
        this.magFilter = magFilter;
        this.internalFormat = internalFormat;
        this.format = format;
        if (this.format == null) {
            this.format = alpha ? Format.RGBA : Format.RGB;
        }
        this.alpha = alpha;
        this.data = data;
    }

    public Texture(Dimension dimension, Filter minFilter, Filter magFilter, InternalFormat internalFormat, Format format, boolean alpha) {
        this(dimension, Type.TWO_DIMENSIONAL, minFilter, magFilter, internalFormat, format, alpha, UBuffer.createByteBuffer(dimension.getWidth() * dimension.getHeight() * 4));
    }

    public Texture(Dimension dimension) {
        this(dimension, Filter.NEAREST, Filter.NEAREST, InternalFormat.RGBA8, Format.RGBA, true);
    }

    public Texture(BufferedImage image) {
        this(Dimension.fromBufferedImage(image), Type.TWO_DIMENSIONAL, Filter.NEAREST, Filter.NEAREST, InternalFormat.RGBA8, null, image.getColorModel().hasAlpha(), ResourceConverter.toByteBuffer(image));
    }

    public Texture(BufferedImage image, Dimension dimension) {
        this(Dimension.fromBufferedImage(image), Type.TWO_DIMENSIONAL, Filter.NEAREST, Filter.NEAREST, InternalFormat.RGBA8, null, image.getColorModel().hasAlpha(), ResourceConverter.toByteBuffer(image, dimension));
    }

    public Texture(TexturableData data) {
        this(data.getDimension(), data.getType(), data.getMinFilter(), data.getMagFilter(), data.getInternalFormat(), data.getFormat(), data.hasAlpha(), data.getData());
    }

    public int getID() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public Filter getMinFilter() {
        return this.minFilter;
    }

    public Filter getMagFilter() {
        return this.magFilter;
    }

    public Format getFormat() {
        return this.format;
    }

    public InternalFormat getInternalFormat() {
        return this.internalFormat;
    }

    public Dimension getDimension() {
        return this;
    }

    public boolean hasAlpha() {
        return this.alpha;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setID(int id) {
        this.id = id;
    }
}

