/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.fileparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.achtern.AchternEngine.core.bootstrap.NativeObject;
import org.achtern.AchternEngine.core.resource.ResourceLoader;
import org.achtern.AchternEngine.core.resource.fileparser.GLSLParser;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.GLSLScript;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.Uniform;
import org.yaml.snakeyaml.Yaml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLProgram
extends NativeObject {
    protected String name;
    protected String source;
    protected Map parsed;
    protected List<GLSLScript> scripts;
    protected Map<String, Uniform> cachedUniforms;
    protected Map<String, Uniform> cachedExpandedUniforms;
    protected GLSLParser parser;
    private Yaml yaml;

    public GLSLProgram(String name, String program) {
        this.name = name;
        this.source = program;
        this.yaml = new Yaml();
        this.scripts = new ArrayList<GLSLScript>();
    }

    public Uniform getUniform(String name) {
        this.getUniforms();
        return this.cachedUniforms.get(name);
    }

    public Uniform getExpandedUniform(String name) {
        this.getExpandedUniforms();
        return this.cachedExpandedUniforms.get(name);
    }

    public List<Uniform> getUniforms() {
        if (this.cachedUniforms != null) {
            return new ArrayList<Uniform>(this.cachedUniforms.values());
        }
        HashMap<String, Uniform> uniforms = new HashMap<String, Uniform>();
        for (GLSLScript s : this.getScripts()) {
            for (Uniform u : s.getUniforms()) {
                uniforms.put(u.getName(), u);
            }
        }
        this.cachedUniforms = uniforms;
        return this.getUniforms();
    }

    public List<Uniform> getExpandedUniforms() {
        if (this.cachedExpandedUniforms != null) {
            return new ArrayList<Uniform>(this.cachedExpandedUniforms.values());
        }
        HashMap<String, Uniform> uniforms = new HashMap<String, Uniform>();
        for (GLSLScript s : this.getScripts()) {
            for (Uniform u : s.getExpandedUniforms()) {
                uniforms.put(u.getName(), u);
            }
        }
        this.cachedExpandedUniforms = uniforms;
        return this.getExpandedUniforms();
    }

    public void parse(GLSLParser parser) throws Exception {
        this.setParser(parser);
        this.parsed = (Map)this.yaml.load(this.source);
        this.validate(this.parsed);
        String text = ResourceLoader.getShader((String)this.parsed.get("vertex"));
        this.pushShader(text, GLSLScript.Type.VERTEX_SHADER);
        text = ResourceLoader.getShader((String)this.parsed.get("fragment"));
        this.pushShader(text, GLSLScript.Type.FRAGMENT_SHADER);
        if (this.parsed.containsKey("geometry")) {
            text = ResourceLoader.getShader((String)this.parsed.get("geometry"));
            this.pushShader(text, GLSLScript.Type.GEOMETRY_SHADER);
        }
    }

    protected void pushShader(String source, GLSLScript.Type type) {
        GLSLScript shader = new GLSLScript(this.name, type);
        shader.setSource(source);
        this.getParser().process(shader);
        this.scripts.add(shader);
    }

    protected void validate(Map map) {
        this.checkAndThrow("version", map);
        this.checkAndThrow("vertex", map);
        this.checkAndThrow("fragment", map);
    }

    protected void checkAndThrow(String key, Map map) {
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException("'" + key + "' key missing in ShaderProgram <" + this.name + ">.");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public Map getParsed() {
        return this.parsed;
    }

    public List<GLSLScript> getScripts() {
        return this.scripts;
    }

    public GLSLParser getParser() {
        return this.parser;
    }

    public void setParser(GLSLParser parser) {
        this.parser = parser;
    }
}

