/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.fileparser.mesh;

import java.util.ArrayList;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedModel {
    protected ArrayList<Vector3f> positions = new ArrayList();
    protected ArrayList<Vector2f> texCoord = new ArrayList();
    protected ArrayList<Vector3f> normal = new ArrayList();
    protected ArrayList<Integer> indices = new ArrayList();

    public void calcNormals() {
        for (int i = 0; i < this.getIndices().size(); i += 3) {
            int i0 = this.getIndices().get(i);
            int i1 = this.getIndices().get(i + 1);
            int i2 = this.getIndices().get(i + 2);
            Vector3f v1 = this.getPositions().get(i1).sub(this.getPositions().get(i0));
            Vector3f v2 = this.getPositions().get(i2).sub(this.getPositions().get(i0));
            Vector3f normal = v1.cross(v2).normalized();
            this.getNormal().get(i0).set(this.getNormal().get(i0).add(normal));
            this.getNormal().get(i1).set(this.getNormal().get(i1).add(normal));
            this.getNormal().get(i2).set(this.getNormal().get(i2).add(normal));
        }
        for (Vector3f normal : this.getNormal()) {
            normal.normalize();
        }
    }

    public ArrayList<Vector3f> getPositions() {
        return this.positions;
    }

    public ArrayList<Vector2f> getTexCoord() {
        return this.texCoord;
    }

    public ArrayList<Vector3f> getNormal() {
        return this.normal;
    }

    public ArrayList<Integer> getIndices() {
        return this.indices;
    }

    public void setPositions(ArrayList<Vector3f> positions) {
        this.positions = positions;
    }

    public void setTexCoord(ArrayList<Vector2f> texCoord) {
        this.texCoord = texCoord;
    }

    public void setNormal(ArrayList<Vector3f> normal) {
        this.normal = normal;
    }

    public void setIndices(ArrayList<Integer> indices) {
        this.indices = indices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexedModel)) {
            return false;
        }
        IndexedModel other = (IndexedModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ArrayList<Vector3f> this$positions = this.getPositions();
        ArrayList<Vector3f> other$positions = other.getPositions();
        if (this$positions == null ? other$positions != null : !((Object)this$positions).equals(other$positions)) {
            return false;
        }
        ArrayList<Vector2f> this$texCoord = this.getTexCoord();
        ArrayList<Vector2f> other$texCoord = other.getTexCoord();
        if (this$texCoord == null ? other$texCoord != null : !((Object)this$texCoord).equals(other$texCoord)) {
            return false;
        }
        ArrayList<Vector3f> this$normal = this.getNormal();
        ArrayList<Vector3f> other$normal = other.getNormal();
        if (this$normal == null ? other$normal != null : !((Object)this$normal).equals(other$normal)) {
            return false;
        }
        ArrayList<Integer> this$indices = this.getIndices();
        ArrayList<Integer> other$indices = other.getIndices();
        return !(this$indices == null ? other$indices != null : !((Object)this$indices).equals(other$indices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexedModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ArrayList<Vector3f> $positions = this.getPositions();
        result = result * 59 + ($positions == null ? 0 : ((Object)$positions).hashCode());
        ArrayList<Vector2f> $texCoord = this.getTexCoord();
        result = result * 59 + ($texCoord == null ? 0 : ((Object)$texCoord).hashCode());
        ArrayList<Vector3f> $normal = this.getNormal();
        result = result * 59 + ($normal == null ? 0 : ((Object)$normal).hashCode());
        ArrayList<Integer> $indices = this.getIndices();
        result = result * 59 + ($indices == null ? 0 : ((Object)$indices).hashCode());
        return result;
    }

    public String toString() {
        return "IndexedModel(positions=" + this.getPositions() + ", texCoord=" + this.getTexCoord() + ", normal=" + this.getNormal() + ", indices=" + this.getIndices() + ")";
    }
}

