/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.parser;

import org.achtern.AchternEngine.core.resource.fileparser.ParsingException;
import org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.builder.manager.RequireManager;
import org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.builder.manager.VaryingManager;
import org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.parser.PipelineParser;
import org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.statement.ProvideParser;
import org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.statement.RequireParser;
import org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.validator.MainBlockValidator;

public class VertexParser
implements PipelineParser {
    protected String source;
    protected final RequireManager requireManager = new RequireManager();
    protected final VaryingManager varyingManager = new VaryingManager();

    public void parse() throws ParsingException {
        MainBlockValidator validator = new MainBlockValidator();
        if (!validator.isValid(this.getSource())) {
            throw new ParsingException("No valid 'void main () {/.../}' method found!");
        }
        String[] lines = this.getSource().split("\n");
        RequireParser requireParser = new RequireParser();
        ProvideParser provideParser = new ProvideParser();
        for (String l : lines) {
            String tL = l.trim();
            if (requireParser.test(tL)) {
                this.requireManager.add(requireParser.getType(tL), requireParser.getName(tL));
                continue;
            }
            if (!provideParser.test(tL)) continue;
            this.varyingManager.add(provideParser.getType(tL), provideParser.getName(tL));
        }
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }
}

