/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.statement;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.achtern.AchternEngine.core.resource.fileparser.nextgenshader.statement.StatementParser;

public abstract class BasicStatementParser
implements StatementParser {
    protected final Pattern pattern;
    protected String target;
    private Matcher targetMatcher;

    protected BasicStatementParser(Pattern pattern) {
        this.pattern = pattern;
    }

    protected BasicStatementParser(Pattern pattern, String target) {
        this(pattern);
        this.target = target;
    }

    public boolean test(String line) {
        return this.pattern.matcher(line).find();
    }

    public boolean test() {
        return this.getTargetMatcher().find();
    }

    protected String getGroup(String input, int i) {
        Matcher m = this.pattern.matcher(input);
        return this.getGroup(m, i);
    }

    protected String getGroup(String input, GroupProvider provider) {
        return this.getGroup(input, provider.get());
    }

    protected String getGroup(int i) {
        return this.getGroup(this.getTargetMatcher(), i);
    }

    protected String getGroup(GroupProvider provider) {
        return this.getGroup(provider.get());
    }

    public Matcher getTargetMatcher() {
        if (this.targetMatcher == null) {
            this.targetMatcher = this.getPattern().matcher(this.getTarget());
        }
        return this.targetMatcher;
    }

    private String getGroup(Matcher m, int i) {
        if (m.matches()) {
            return m.group(i);
        }
        return "";
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getTarget() {
        return this.target;
    }

    public static interface GroupProvider {
        public int get();
    }
}

