/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.loader;

import java.util.ArrayList;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Vertex;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.resource.fileparser.LineBasedParser;
import org.achtern.AchternEngine.core.resource.fileparser.mesh.IndexedModel;
import org.achtern.AchternEngine.core.resource.fileparser.mesh.OBJParser;
import org.achtern.AchternEngine.core.resource.loader.AsciiFileLoader;
import org.achtern.AchternEngine.core.resource.loader.LoadingException;
import org.achtern.AchternEngine.core.util.UInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshLoader
extends AsciiFileLoader<Mesh> {
    protected OBJParser objParser = new OBJParser();

    @Override
    public void load(String name, String file) throws LoadingException {
        String[] lines;
        if (this.objParser.hasRun()) {
            return;
        }
        for (String l : lines = file.split("\n")) {
            try {
                this.getPreProcessor().parse(l);
            }
            catch (Exception e) {
                throw new LoadingException("Could not load OBJ File", e);
            }
        }
    }

    @Override
    public LineBasedParser getPreProcessor() {
        return this.objParser;
    }

    @Override
    public Mesh get() throws Exception {
        IndexedModel model = this.objParser.toIndexedModel();
        model.calcNormals();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (int i = 0; i < model.getPositions().size(); ++i) {
            Vector3f position = model.getPositions().get(i);
            Vector2f texCoord = model.getTexCoord().get(i);
            Vector3f normal = model.getNormal().get(i);
            vertices.add(new Vertex(position, texCoord, normal));
        }
        Vertex[] vData = new Vertex[vertices.size()];
        vertices.toArray(vData);
        Integer[] iData = new Integer[model.getIndices().size()];
        model.getIndices().toArray(iData);
        return new Mesh(vData, UInteger.toIntArray(iData));
    }
}

