/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.locations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.achtern.AchternEngine.core.resource.ResourceLocation;

public class FileSystemLocation
implements ResourceLocation {
    private File root;

    public FileSystemLocation(String root) {
        this(new File(root));
    }

    public FileSystemLocation(File root) {
        this.root = root;
    }

    public InputStream getStream(String name) {
        File file = new File(this.root, name);
        if (!file.exists()) {
            file = new File(name);
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public URL getURL(String name) {
        File file = new File(this.root, name);
        if (!file.exists()) {
            file = new File(name);
        }
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

