/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph;

import org.achtern.AchternEngine.core.scenegraph.Node;

public class ShortLifeNode
extends Node {
    protected final float maxLifeTime;
    protected float lifeTime;

    public ShortLifeNode(String name, float maxLifeTime) {
        super(name);
        this.maxLifeTime = maxLifeTime;
        this.lifeTime = 0.0f;
    }

    public ShortLifeNode(float maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
        this.lifeTime = 0.0f;
    }

    public void update(float delta) {
        super.update(delta);
        if (this.lifeTime >= this.maxLifeTime) {
            this.getParent().remove(this);
        }
        this.lifeTime += delta;
    }
}

