/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.bounding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Vertex;
import org.achtern.AchternEngine.core.rendering.mesh.WireBox;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.bounding.BoundingObject;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundingBox
extends BoundingObject {
    protected Vector3f extents;

    public static Node makeNode(BoundingBox bb) {
        WireBox wireBox = new WireBox(bb.getExtents());
        Figure figure = new Figure("BoundingBox Figure", wireBox);
        Node node = new Node("BoundingBox").add(figure);
        node.getTransform().setPosition(bb.getCenter().get());
        return node;
    }

    public BoundingBox(Vector3f center, Vector3f extents) {
        super(center);
        this.extents = extents;
    }

    public BoundingBox(Vector3f center, float x, float y, float z) {
        this(center, new Vector3f(x, y, z));
    }

    public BoundingBox(BoundingBox copy) {
        this(copy.getCenter(), copy.getExtents());
    }

    public BoundingBox copy(BoundingBox copy) {
        this.setExtents(copy.getExtents());
        this.setCenter(copy.getCenter());
        this.setCheckPlane(copy.getCheckPlane());
        return this;
    }

    public BoundingBox fromVertices(Vertex[] vertices) {
        return this.fromVertices(vertices, 0.0f);
    }

    public BoundingBox fromVertices(Vertex[] vertices, float padding) {
        ArrayList<Vector3f> points = new ArrayList<Vector3f>(vertices.length);
        for (Vertex v : vertices) {
            points.add(v.getPos());
        }
        return this.fromPoints(points);
    }

    @Override
    public BoundingBox fromPoints(List<Vector3f> vectors) {
        return this.fromPoints(vectors, 0.0f);
    }

    public BoundingBox fromPoints(List<Vector3f> vectors, float padding) {
        if (vectors.size() == 0) {
            throw new IllegalArgumentException("At least 1 vertex is needed to calculate a BoundingBox");
        }
        ArrayList<Float> xs = new ArrayList<Float>(vectors.size());
        ArrayList<Float> ys = new ArrayList<Float>(vectors.size());
        ArrayList<Float> zs = new ArrayList<Float>(vectors.size());
        for (Vector3f point : vectors) {
            xs.add(Float.valueOf(point.getX()));
            ys.add(Float.valueOf(point.getY()));
            zs.add(Float.valueOf(point.getZ()));
        }
        float maxX = ((Float)Collections.max(xs)).floatValue();
        float minX = ((Float)Collections.min(xs)).floatValue();
        float maxY = ((Float)Collections.max(ys)).floatValue();
        float minY = ((Float)Collections.min(ys)).floatValue();
        float maxZ = ((Float)Collections.max(zs)).floatValue();
        float minZ = ((Float)Collections.min(zs)).floatValue();
        this.setCenter(new Vector3f((maxX + minX) / 2.0f, (maxY + minY) / 2.0f, (maxZ + minZ) / 2.0f));
        this.setExtents(new Vector3f(maxX - this.getCenter().getX() + padding, maxY - this.getCenter().getY() + padding, maxZ - this.getCenter().getZ() + padding));
        return this;
    }

    @Override
    public BoundingObject merge(BoundingObject other) {
        if (other == null) {
            return this;
        }
        if (other instanceof BoundingBox) {
            return this.merge((BoundingBox)other);
        }
        throw new UnsupportedOperationException("Cannot merge with BoundingObject other then BoundingBox");
    }

    public BoundingBox merge(BoundingBox bb) {
        List<Vector3f> bb1 = this.toPoints();
        List<Vector3f> bb2 = bb.toPoints();
        for (Vector3f v : bb1) {
            v.set(v.add(this.getCenter()));
        }
        for (Vector3f v : bb2) {
            v.set(v.add(bb.getCenter()));
        }
        bb1.addAll(bb2);
        this.fromPoints((List)bb1);
        return this;
    }

    @Override
    public boolean intersects(BoundingObject bo) {
        if (bo instanceof BoundingBox) {
            return this.intersects((BoundingBox)bo);
        }
        throw new UnsupportedOperationException("Cannot merge with BoundingObject other then BoundingBox");
    }

    public boolean intersects(BoundingBox bb) {
        if (this.getCenter().getX() - this.getExtents().getX() > bb.getCenter().getX() + bb.getExtents().getX()) {
            return false;
        }
        if (this.getCenter().getX() + this.getExtents().getX() < bb.getCenter().getX() - bb.getExtents().getX()) {
            return false;
        }
        if (this.getCenter().getY() - this.getExtents().getY() > bb.getCenter().getY() + bb.getExtents().getY()) {
            return false;
        }
        if (this.getCenter().getY() + this.getExtents().getY() < bb.getCenter().getY() - bb.getExtents().getY()) {
            return false;
        }
        if (this.getCenter().getZ() - this.getExtents().getZ() > bb.getCenter().getZ() + bb.getExtents().getZ()) {
            return false;
        }
        return !(this.getCenter().getZ() + this.getExtents().getZ() < bb.getCenter().getZ() - bb.getExtents().getZ());
    }

    @Override
    public boolean contains(Vector3f point) {
        return Math.abs(this.getCenter().getX() - point.getX()) < this.getExtents().getX() && Math.abs(this.getCenter().getY() - point.getY()) < this.getExtents().getY() && Math.abs(this.getCenter().getZ() - point.getZ()) < this.getExtents().getZ();
    }

    public Node makeNode() {
        return BoundingBox.makeNode(this);
    }

    public Vertex[] toVertexArray() {
        return new Vertex[]{new Vertex(this.getExtents().mul(new Vector3f(-1.0f, -1.0f, 1.0f))), new Vertex(this.getExtents().mul(new Vector3f(1.0f, -1.0f, 1.0f))), new Vertex(this.getExtents().mul(new Vector3f(1.0f, 1.0f, 1.0f))), new Vertex(this.getExtents().mul(new Vector3f(-1.0f, 1.0f, 1.0f))), new Vertex(this.getExtents().mul(new Vector3f(-1.0f, -1.0f, -1.0f))), new Vertex(this.getExtents().mul(new Vector3f(1.0f, -1.0f, -1.0f))), new Vertex(this.getExtents().mul(new Vector3f(1.0f, 1.0f, -1.0f))), new Vertex(this.getExtents().mul(new Vector3f(-1.0f, 1.0f, -1.0f)))};
    }

    public List<Vector3f> toPoints() {
        ArrayList<Vector3f> points = new ArrayList<Vector3f>(8);
        points.add(this.getExtents().mul(new Vector3f(-1.0f, -1.0f, 1.0f)));
        points.add(this.getExtents().mul(new Vector3f(1.0f, -1.0f, 1.0f)));
        points.add(this.getExtents().mul(new Vector3f(1.0f, 1.0f, 1.0f)));
        points.add(this.getExtents().mul(new Vector3f(-1.0f, 1.0f, 1.0f)));
        points.add(this.getExtents().mul(new Vector3f(-1.0f, -1.0f, -1.0f)));
        points.add(this.getExtents().mul(new Vector3f(1.0f, -1.0f, -1.0f)));
        points.add(this.getExtents().mul(new Vector3f(1.0f, 1.0f, -1.0f)));
        points.add(this.getExtents().mul(new Vector3f(-1.0f, 1.0f, -1.0f)));
        return points;
    }

    @Override
    public String toString() {
        return "center=" + this.getCenter() + ";extents=" + this.getExtents();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BoundingBox)) {
            return false;
        }
        BoundingBox bb = (BoundingBox)obj;
        return bb.getExtents().equals(this.getExtents()) && bb.getCenter().equals(this.getCenter()) && bb.getCheckPlane() == this.getCheckPlane();
    }

    public BoundingBox() {
    }

    public Vector3f getExtents() {
        return this.extents;
    }

    public void setExtents(Vector3f extents) {
        this.extents = extents;
    }
}

