/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.bounding;

import java.util.List;
import org.achtern.AchternEngine.core.math.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BoundingObject
implements Cloneable {
    protected Vector3f center;
    protected int checkPlane = 0;

    public BoundingObject() {
    }

    public BoundingObject(Vector3f center) {
        this.center = center;
    }

    public abstract BoundingObject fromPoints(List<Vector3f> var1);

    public abstract BoundingObject merge(BoundingObject var1);

    public abstract boolean intersects(BoundingObject var1);

    public abstract boolean contains(Vector3f var1);

    public BoundingObject clone() throws CloneNotSupportedException {
        BoundingObject clone = (BoundingObject)super.clone();
        clone.setCenter(this.center.clone());
        return clone;
    }

    public final float distanceTo(Vector3f point) {
        return this.getCenter().euclidean(point);
    }

    public Vector3f getCenter(Vector3f store) {
        store.set(this.getCenter());
        return store;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public int getCheckPlane() {
        return this.checkPlane;
    }

    public void setCenter(Vector3f center) {
        this.center = center;
    }

    public void setCheckPlane(int checkPlane) {
        this.checkPlane = checkPlane;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundingObject)) {
            return false;
        }
        BoundingObject other = (BoundingObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vector3f this$center = this.getCenter();
        Vector3f other$center = other.getCenter();
        if (this$center == null ? other$center != null : !((Object)this$center).equals(other$center)) {
            return false;
        }
        return this.getCheckPlane() == other.getCheckPlane();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BoundingObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3f $center = this.getCenter();
        result = result * 59 + ($center == null ? 0 : $center.hashCode());
        result = result * 59 + this.getCheckPlane();
        return result;
    }

    public String toString() {
        return "BoundingObject(center=" + this.getCenter() + ", checkPlane=" + this.getCheckPlane() + ")";
    }
}

