/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity.controller;

import org.achtern.AchternEngine.core.Transform;
import org.achtern.AchternEngine.core.input.Key;
import org.achtern.AchternEngine.core.input.MouseButton;
import org.achtern.AchternEngine.core.input.adapter.InputAdapter;
import org.achtern.AchternEngine.core.input.event.listener.KeyListener;
import org.achtern.AchternEngine.core.input.event.listener.MouseListener;
import org.achtern.AchternEngine.core.input.event.listener.trigger.KeyTrigger;
import org.achtern.AchternEngine.core.input.event.listener.trigger.MouseButtonTrigger;
import org.achtern.AchternEngine.core.input.event.payload.KeyEvent;
import org.achtern.AchternEngine.core.input.event.payload.MouseEvent;
import org.achtern.AchternEngine.core.scenegraph.entity.QuickEntity;

public class MouseLook
extends QuickEntity
implements KeyListener,
MouseListener {
    protected float sensitivity;
    protected boolean mouselock = false;
    protected Key unlockKey;
    protected boolean skip = true;

    public MouseLook(float sensitivity) {
        this(sensitivity, Key.ESCAPE);
    }

    public MouseLook(float sensitivity, Key unlockKey) {
        this.sensitivity = sensitivity;
        this.unlockKey = unlockKey;
    }

    public void attached() {
        this.registerListener();
    }

    protected void registerListener() {
        this.getEngine().getGame().getInputManager().getKeyMap().register(new KeyTrigger(this.unlockKey), (KeyListener)this);
        this.getEngine().getGame().getInputManager().getMouseMap().register(new MouseButtonTrigger(MouseButton.LEFT), (MouseListener)this).register(this);
    }

    public void onAction(KeyEvent event) {
        if (!this.isMouselock()) {
            return;
        }
        event.getInputAdapter().setCursor(true);
        this.setMouselock(false);
    }

    public void onAction(MouseEvent event) {
        if (event.getButton() == null) {
            if (!this.isMouselock()) {
                return;
            }
            if (this.skip) {
                this.skip = false;
                return;
            }
            this.getTransform().rotate(this.getTransform().getRotation().getRight(), -event.getMouseDelta().getY() * this.sensitivity);
            this.getTransform().rotate(Transform.Y_AXIS, event.getMouseDelta().getX() * this.sensitivity);
            this.centerMouse(event.getInputAdapter());
        } else {
            event.getInputAdapter().setCursor(false);
            this.setMouselock(true);
            this.centerMouse(event.getInputAdapter());
            this.skip = true;
        }
    }

    protected void centerMouse(InputAdapter input) {
        input.setMousePosition(this.getEngine().getWindow().getCenter());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MouseLook)) {
            return false;
        }
        MouseLook other = (MouseLook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getSensitivity(), other.getSensitivity()) != 0) {
            return false;
        }
        if (this.isMouselock() != other.isMouselock()) {
            return false;
        }
        Key this$unlockKey = this.getUnlockKey();
        Key other$unlockKey = other.getUnlockKey();
        if (this$unlockKey == null ? other$unlockKey != null : !((Object)((Object)this$unlockKey)).equals((Object)other$unlockKey)) {
            return false;
        }
        return this.isSkip() == other.isSkip();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MouseLook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getSensitivity());
        result = result * 59 + (this.isMouselock() ? 79 : 97);
        Key $unlockKey = this.getUnlockKey();
        result = result * 59 + ($unlockKey == null ? 0 : ((Object)((Object)$unlockKey)).hashCode());
        result = result * 59 + (this.isSkip() ? 79 : 97);
        return result;
    }

    public float getSensitivity() {
        return this.sensitivity;
    }

    public boolean isMouselock() {
        return this.mouselock;
    }

    public Key getUnlockKey() {
        return this.unlockKey;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSensitivity(float sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setMouselock(boolean mouselock) {
        this.mouselock = mouselock;
    }

    public void setUnlockKey(Key unlockKey) {
        this.unlockKey = unlockKey;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String toString() {
        return "MouseLook(sensitivity=" + this.getSensitivity() + ", mouselock=" + this.isMouselock() + ", unlockKey=" + (Object)((Object)this.getUnlockKey()) + ", skip=" + this.isSkip() + ")";
    }
}

