/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity.controller;

import org.achtern.AchternEngine.core.input.Key;
import org.achtern.AchternEngine.core.input.event.listener.KeyListener;
import org.achtern.AchternEngine.core.input.event.listener.trigger.KeyTrigger;
import org.achtern.AchternEngine.core.input.event.payload.KeyEvent;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.scenegraph.entity.QuickEntity;

public class SimpleMover
extends QuickEntity
implements KeyListener {
    protected float speed;
    protected Key forwardKey;
    protected Key backKey;
    protected Key leftKey;
    protected Key rightKey;

    public SimpleMover(float speed) {
        this(speed, Key.W, Key.S, Key.A, Key.D);
    }

    public SimpleMover(float speed, Key forwardKey, Key backKey, Key leftKey, Key rightKey) {
        this.speed = speed;
        this.forwardKey = forwardKey;
        this.backKey = backKey;
        this.leftKey = leftKey;
        this.rightKey = rightKey;
    }

    public void attached() {
        this.registerListener();
    }

    protected void registerListener() {
        this.getEngine().getGame().getInputManager().getKeyMap().register(new KeyTrigger(this.forwardKey, KeyTrigger.Type.PRESS), (KeyListener)this).register(new KeyTrigger(this.backKey, KeyTrigger.Type.PRESS), (KeyListener)this).register(new KeyTrigger(this.leftKey, KeyTrigger.Type.PRESS), (KeyListener)this).register(new KeyTrigger(this.rightKey, KeyTrigger.Type.PRESS), (KeyListener)this);
    }

    protected void move(Vector3f dir, float amt) {
        this.move(dir.mul(amt));
    }

    protected void move(Vector3f amount) {
        this.getTransform().setPosition(this.getTransform().getPosition().add(amount));
    }

    public void onAction(KeyEvent event) {
        float amt = this.getSpeed() * event.getDelta();
        if (event.getKey().equals((Object)this.forwardKey)) {
            this.move(this.getTransform().getRotation().getForward(), amt);
        } else if (event.getKey().equals((Object)this.backKey)) {
            this.move(this.getTransform().getRotation().getForward(), -amt);
        } else if (event.getKey().equals((Object)this.leftKey)) {
            this.move(this.getTransform().getRotation().getLeft(), amt);
        } else if (event.getKey().equals((Object)this.rightKey)) {
            this.move(this.getTransform().getRotation().getRight(), amt);
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }
}

