/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity.debug;

import org.achtern.AchternEngine.core.Transform;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.Material;
import org.achtern.AchternEngine.core.rendering.generator.ImageGenerator;
import org.achtern.AchternEngine.core.rendering.mesh.Arrow;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;

public class AxisDebugger
extends Node {
    public AxisDebugger(String name) {
        super(name);
        this.pushFigure(new Arrow(), Color.RED, "X-Axis");
        this.pushFigure(new Arrow(), Color.GREEN, "Y-Axis");
        this.pushFigure(new Arrow(), Color.BLUE, "Z-Axis");
    }

    public AxisDebugger() {
        this("AxisDebugger");
    }

    private void pushFigure(Mesh mesh, Color color, String name) {
        Figure f = new Figure("Axis", mesh);
        Material m = new Material();
        m.addTexture("diffuse", new Texture(ImageGenerator.bytesFromColor(color)));
        f.setMaterial(m);
        Node n = new Node("AxisDebugger/" + name);
        n.add(f);
        this.add(n);
        if (name.equals("Z-Axis")) {
            n.getTransform().rotate(Transform.Z_AXIS, -90.0f);
        } else if (name.equals("X-Axis")) {
            n.getTransform().rotate(Transform.X_AXIS, 90.0f);
        }
    }
}

