/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.scanning;

import java.util.ArrayList;
import java.util.List;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.entity.Entity;
import org.achtern.AchternEngine.core.scenegraph.scanning.SceneGraphRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityRetriever
implements SceneGraphRetriever<Entity> {
    protected List<Node> nodes = new ArrayList<Node>();
    protected List<Entity> entities = new ArrayList<Entity>();

    @Override
    public void scan(Node node) {
        this.nodes.clear();
        this.entities.clear();
        this.nodes.add(node);
        this.entities.addAll(this.getAll(node));
    }

    @Override
    public List<Entity> getAll() {
        return this.entities;
    }

    @Override
    public List<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public boolean contained() {
        return this.getAll().size() > 0;
    }

    @Override
    public <E extends Entity> List<E> getAll(Class<E> filter) {
        ArrayList<E> filtered = new ArrayList<E>();
        for (Entity e : this.getAll()) {
            if (!filter.isInstance(e)) continue;
            filtered.add(filter.cast(e));
        }
        return filtered;
    }

    protected List<Entity> getAll(Node node) {
        return this.getAll(node, true);
    }

    protected List<Entity> getAll(Node node, boolean addNodes) {
        ArrayList<Entity> flattenedList = new ArrayList<Entity>();
        flattenedList.addAll(node.getEntities());
        ArrayList<Node> children = new ArrayList<Node>(node.getChildren().values());
        for (Node n : children) {
            if (addNodes) {
                this.nodes.add(n);
            }
            flattenedList.addAll(this.getAll(n, addNodes));
        }
        return flattenedList;
    }
}

