/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FPS {
    public static final Logger LOGGER = LoggerFactory.getLogger(FPS.class);
    private int frames = 0;
    private double frameCounter = 0.0;
    private int fps = 0;
    private float average;

    public void passed(double passed) {
        this.frameCounter += passed;
    }

    public void rendered() {
        ++this.frames;
    }

    public void display() {
        if (this.frameCounter >= 1.0) {
            this.fps = this.frames;
            if (this.average == 0.0f) {
                this.average = this.fps;
            } else {
                this.average += (float)this.fps;
                this.average /= 2.0f;
            }
            LOGGER.info("FPS: {} (Average: {})", (Object)this.fps, (Object)Float.valueOf((float)Math.round(this.average * 100.0f) / 100.0f));
            this.frames = 0;
            this.frameCounter = 0;
        }
    }

    public int get() {
        return this.fps;
    }

    public float getAverage() {
        return this.average;
    }
}

