/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.lwjgl.rendering.binding;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.achtern.AchternEngine.core.rendering.binding.DataBinder;
import org.achtern.AchternEngine.core.rendering.binding.IDGenerator;
import org.achtern.AchternEngine.core.rendering.binding.UniformManager;
import org.achtern.AchternEngine.core.rendering.exception.FrameBufferException;
import org.achtern.AchternEngine.core.rendering.framebuffer.FrameBuffer;
import org.achtern.AchternEngine.core.rendering.framebuffer.RenderBuffer;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.rendering.mesh.MeshData;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.rendering.state.RenderEngineState;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.fileparser.GLSLProgram;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.GLSLScript;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.Variable;
import org.achtern.AchternEngine.core.util.UBuffer;
import org.achtern.AchternEngine.lwjgl.rendering.binding.LWJGLIDGenerator;
import org.achtern.AchternEngine.lwjgl.rendering.binding.LWJGLUniformManager;
import org.achtern.AchternEngine.lwjgl.util.GLEnum;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LWJGLDataBinder
implements DataBinder {
    public static final Logger LOGGER = LoggerFactory.getLogger(DataBinder.class);
    protected LWJGLIDGenerator idGen;
    protected LWJGLUniformManager uniformManager;
    protected RenderEngineState state;
    private IntBuffer intBuffer = UBuffer.createIntBuffer(16);

    public LWJGLDataBinder(RenderEngineState state) {
        this.state = state;
        this.idGen = new LWJGLIDGenerator();
        this.uniformManager = new LWJGLUniformManager();
    }

    public void bind(Texture texture) {
        this.bind(texture, 0);
    }

    public void bind(Texture texture, int samplerslot) {
        if (samplerslot < 0) {
            throw new IllegalArgumentException("SamplerSlot MUST be a positive integer!");
        }
        if (texture.getID() == -1) {
            this.getIDGenerator().generate(texture);
            this.upload(texture);
        }
        if (this.state.getBoundTexture() != null && this.state.getBoundTexture().getID() == texture.getID()) {
            return;
        }
        GL13.glActiveTexture((int)(33984 + samplerslot));
        GL11.glBindTexture((int)GLEnum.getGLEnum(texture.getType()), (int)texture.getID());
        this.state.setBound(texture);
    }

    public void upload(Texture texture) {
        this.bind(texture);
        int type = GLEnum.getGLEnum(texture.getType());
        GL11.glTexParameteri((int)type, (int)10242, (int)33071);
        GL11.glTexParameteri((int)type, (int)10243, (int)33071);
        GL11.glTexParameteri((int)type, (int)10241, (int)GLEnum.getGLEnum(texture.getMinFilter()));
        GL11.glTexParameteri((int)type, (int)10240, (int)GLEnum.getGLEnum(texture.getMagFilter()));
        GL11.glTexImage2D((int)type, (int)0, (int)GLEnum.getGLEnum(texture.getInternalFormat()), (int)texture.getDimension().getWidth(), (int)texture.getDimension().getHeight(), (int)0, (int)GLEnum.getGLEnum(texture.getFormat()), (int)5121, (ByteBuffer)texture.getData());
        GL11.glTexParameteri((int)type, (int)33084, (int)0);
        GL11.glTexParameteri((int)type, (int)33085, (int)0);
    }

    public void bind(Mesh mesh) {
        if (mesh == null) {
            GL30.glBindVertexArray((int)0);
        } else {
            int id = mesh.getData().getID();
            if (this.state.getBoundMesh() != null && this.state.getBoundMesh().getData().getID() == id) {
                return;
            }
            GL30.glBindVertexArray((int)id);
        }
        this.state.setBound(mesh);
    }

    public void upload(Mesh mesh) {
        MeshData data = mesh.getData();
        if (data.getID() != -1) {
            LOGGER.warn("MeshData already uploaded to context. Re-uploading...");
        }
        this.getIDGenerator().generate(mesh);
        this.bind(mesh);
        GL15.glBindBuffer((int)34962, (int)data.getVbo());
        GL15.glBufferData((int)34962, (FloatBuffer)((FloatBuffer)UBuffer.create(data.getVertices()).flip()), (int)35044);
        GL15.glBindBuffer((int)34963, (int)data.getIbo());
        GL15.glBufferData((int)34963, (IntBuffer)((IntBuffer)UBuffer.create(data.getIndices()).flip()), (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)32, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)32, (long)12L);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)32, (long)20L);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        this.bind((Mesh)null);
    }

    public void draw(Mesh mesh) {
        if (mesh.getData().getID() == -1) {
            this.upload(mesh);
        }
        this.bind(mesh);
        GL11.glDrawElements((int)GLEnum.getGLEnum(mesh.getData().getMode()), (int)mesh.getData().getSize(), (int)5125, (long)0L);
    }

    public void bind(Shader shader) {
        if (shader.getProgram().getID() == -1) {
            this.upload(shader);
        }
        if (this.state.getBoundShader() != null && this.state.getBoundShader().getProgram().getID() == shader.getProgram().getID()) {
            return;
        }
        GL20.glUseProgram((int)shader.getProgram().getID());
        this.state.setBound(shader);
    }

    public void upload(Shader shader) {
        String error;
        GLSLProgram program = shader.getProgram();
        if (program.getID() == -1) {
            this.getIDGenerator().generate(shader);
        }
        for (GLSLScript script : program.getScripts()) {
            GL20.glShaderSource((int)script.getID(), (CharSequence)script.getSource());
            GL20.glCompileShader((int)script.getID());
            if (GL20.glGetShaderi((int)script.getID(), (int)35713) == 0) {
                LOGGER.warn(GL20.glGetShaderInfoLog((int)script.getID(), (int)1024));
            }
            GL20.glAttachShader((int)program.getID(), (int)script.getID());
        }
        GL20.glLinkProgram((int)program.getID());
        if (GL20.glGetProgrami((int)program.getID(), (int)35714) == 0) {
            LOGGER.warn("Link Status: {} @ {}", (Object)GL20.glGetProgramInfoLog((int)program.getID(), (int)1024), (Object)shader.getClass().getSimpleName());
        }
        GL20.glValidateProgram((int)program.getID());
        if (GL20.glGetProgrami((int)program.getID(), (int)35715) == 0 && !(error = GL20.glGetProgramInfoLog((int)program.getID(), (int)1024)).contains("Validation Failed: No vertex array object bound")) {
            LOGGER.warn("Validation Status: {} @ {}", (Object)error, (Object)shader.getClass().getSimpleName());
        }
        this.getUniformManager().addUniforms(shader);
        for (GLSLScript script : program.getScripts()) {
            int loc = 0;
            for (Variable attr : script.getAttributes()) {
                LOGGER.trace("{}: attribute {} got added at {}", new Object[]{this.getClass().getSimpleName(), attr.getName(), loc});
                GL20.glBindAttribLocation((int)program.getID(), (int)loc, (CharSequence)attr.getName());
                ++loc;
            }
        }
    }

    public void bindAsRenderTarget(FrameBuffer fbo) {
        if (fbo == null) {
            this.state.setBound((FrameBuffer)null);
            GL11.glDrawBuffer((int)0);
            GL11.glReadBuffer((int)0);
            return;
        }
        if (this.state.getBoundFbo() != null && this.state.getBoundFbo().getID() == fbo.getID()) {
            return;
        }
        if (fbo.getID() == -1) {
            this.upload(fbo);
        }
        this.bind(fbo);
        if (fbo.sizeColorTargets() == 0) {
            GL11.glDrawBuffer((int)0);
            GL11.glReadBuffer((int)0);
        } else if (fbo.sizeColorTargets() > 1) {
            this.intBuffer.clear();
            for (int i = 0; i < fbo.sizeColorTargets(); ++i) {
                this.intBuffer.put(36064 + i);
            }
            this.intBuffer.flip();
            GL20.glDrawBuffers((IntBuffer)this.intBuffer);
        } else {
            GL11.glDrawBuffer((int)36064);
        }
        try {
            this.validateFrameBufferStatus(fbo);
        }
        catch (FrameBufferException e) {
            LOGGER.error("Error binding FrameBuffer", (Throwable)e);
        }
    }

    public void bind(FrameBuffer fbo) {
        if (this.state.getBoundFbo() != null && this.state.getBoundFbo().getID() == fbo.getID()) {
            return;
        }
        GL30.glBindFramebuffer((int)36160, (int)fbo.getID());
        GL11.glViewport((int)0, (int)0, (int)fbo.getWidth(), (int)fbo.getHeight());
        this.state.setBound(fbo);
    }

    public void upload(FrameBuffer fbo) {
        if (fbo.getID() == -1) {
            this.getIDGenerator().generate(fbo);
        }
        this.bind(fbo);
        RenderBuffer depthTarget = fbo.getDepthTarget();
        if (depthTarget != null) {
            this.fboUploadRenderBufferSetup(fbo, depthTarget, 6402, 36096);
        }
        for (int i = 0; i < fbo.sizeColorTargets(); ++i) {
            RenderBuffer colorTarget = fbo.getColorTarget(i);
            if (colorTarget.getTexture() != null) continue;
            this.fboUploadRenderBufferSetup(fbo, colorTarget, 32854, 36064 + i);
        }
    }

    public IDGenerator getIDGenerator() {
        return this.idGen;
    }

    public UniformManager getUniformManager() {
        return this.uniformManager;
    }

    public RenderEngineState getState() {
        return this.state;
    }

    protected void fboUploadRenderBufferSetup(FrameBuffer fbo, RenderBuffer rbo, int iFormat, int attachment) {
        if (rbo.getTexture() == null) {
            if (rbo.getID() == -1) {
                this.getIDGenerator().generate(rbo);
            }
            GL30.glBindRenderbuffer((int)36161, (int)rbo.getID());
            GL30.glRenderbufferStorage((int)36161, (int)iFormat, (int)fbo.getWidth(), (int)fbo.getHeight());
            GL30.glFramebufferRenderbuffer((int)36160, (int)attachment, (int)36161, (int)rbo.getID());
        } else {
            if (rbo.getTexture().getID() == -1) {
                this.upload(rbo.getTexture());
            }
            GL30.glFramebufferTexture2D((int)36160, (int)attachment, (int)GLEnum.getGLEnum(rbo.getTexture().getType()), (int)rbo.getTexture().getID(), (int)0);
        }
    }

    protected void validateFrameBufferStatus(FrameBuffer fbo) throws FrameBufferException {
        int status = GL30.glCheckFramebufferStatus((int)36160);
        switch (status) {
            case 36053: {
                break;
            }
            case 36054: {
                throw new FrameBufferException("Incomplete or corrupt attachments");
            }
            case 36055: {
                throw new FrameBufferException("FrameBuffer doesn't have any RenderBuffers attached");
            }
            case 36059: {
                throw new FrameBufferException("Incomplete DrawBuffer setup");
            }
            case 36182: {
                throw new FrameBufferException("Incomplete Multisample setup");
            }
            case 36060: {
                throw new FrameBufferException("Incomplete ReadBuffer setup");
            }
            default: {
                throw new UnsupportedOperationException("Unknown FBO status Code " + status);
            }
        }
    }
}

