/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import org.acplt.oncrpc.HasEncoding;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrEnum<T extends HasEncoding<T>>
implements XdrAble {
    private HasEncoding<T> wrapped;

    public XdrEnum(T ee) {
        assert (ee != null);
        this.wrapped = ee;
    }

    public XdrEnum(T ee, XdrDecodingStream xdr) throws OncRpcException, IOException {
        this(ee);
        this.xdrDecode(xdr);
    }

    @Override
    public void xdrEncode(XdrEncodingStream xdr) throws OncRpcException, IOException {
        xdr.xdrEncodeInt(this.wrapped.getEncoding());
    }

    @Override
    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        int v = xdr.xdrDecodeInt();
        this.wrapped = XdrEnum.create(v, this.wrapped);
    }

    public HasEncoding<T> getWrapped() {
        return this.wrapped;
    }

    public T getValue() {
        return (T)this.wrapped;
    }

    public String toString() {
        return "XdrEnum [wrapped=" + this.wrapped + "]";
    }

    public static <T> T create(HasEncoding<T> tt, XdrDecodingStream xdr) throws OncRpcException, IOException {
        int v = xdr.xdrDecodeInt();
        return (T)XdrEnum.create(v, tt);
    }

    public static <T> HasEncoding<T> create(int e, HasEncoding<T> tt) throws OncRpcException {
        for (HasEncoding<T> s : tt.getValues()) {
            if (s.getEncoding() != e) continue;
            return s;
        }
        throw new OncRpcException("can't decode, unexpected value=" + e + " for " + tt.getClass().getName());
    }

    public static <T> T fromEncoding(int e, HasEncoding<T> tt) {
        for (HasEncoding<T> s : tt.getValues()) {
            if (s.getEncoding() != e) continue;
            return (T)s;
        }
        return (T)tt;
    }
}

