/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import org.acplt.oncrpc.server.OncRpcServerAuth;
import org.acplt.oncrpc.server.OncRpcServerAuthNone;
import org.acplt.oncrpc.server.OncRpcServerAuthScheme;
import org.acplt.oncrpc.server.OncRpcServerAuthShort;
import org.acplt.oncrpc.server.OncRpcServerAuthUnix;

final class OncRpcServerAuthSchemes {
    private static final OncRpcServerAuthSchemes defaultRepository = new OncRpcServerAuthSchemes();
    private Node head = null;

    OncRpcServerAuthSchemes() {
    }

    boolean registerScheme(OncRpcServerAuthScheme authenticationScheme) {
        boolean registered = false;
        if (authenticationScheme != null) {
            switch (authenticationScheme.getAuthenticationType()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    if (this.head == null) {
                        this.head = new Node(authenticationScheme);
                        registered = true;
                        break;
                    }
                    Node actualNode = this.head;
                    Node predecessorNode = null;
                    while (actualNode != null) {
                        if (actualNode.scheme.getAuthenticationType() == authenticationScheme.getAuthenticationType()) {
                            actualNode = null;
                            continue;
                        }
                        if (actualNode.scheme.getAuthenticationType() < authenticationScheme.getAuthenticationType()) {
                            predecessorNode = actualNode;
                            actualNode = actualNode.next;
                            continue;
                        }
                        if (actualNode == this.head) {
                            predecessorNode = new Node(authenticationScheme);
                            predecessorNode.next = this.head;
                            this.head = predecessorNode;
                        } else {
                            predecessorNode.next = new Node(authenticationScheme);
                            predecessorNode.next.next = actualNode;
                        }
                        registered = true;
                    }
                    break block0;
                }
            }
        }
        return registered;
    }

    OncRpcServerAuth getNewHandler(int desiredAuthenticationType) {
        OncRpcServerAuth authenticationHandler = null;
        switch (desiredAuthenticationType) {
            case 0: {
                authenticationHandler = OncRpcServerAuthNone.AUTH_NONE;
                break;
            }
            case 2: {
                authenticationHandler = new OncRpcServerAuthShort();
                break;
            }
            case 1: {
                authenticationHandler = new OncRpcServerAuthUnix();
                break;
            }
            default: {
                Node actualNode = this.head;
                while (authenticationHandler == null && actualNode != null) {
                    if (actualNode.scheme.getAuthenticationType() == desiredAuthenticationType) {
                        authenticationHandler = actualNode.scheme.getNewHandler();
                        continue;
                    }
                    if (actualNode.scheme.getAuthenticationType() > desiredAuthenticationType) {
                        actualNode = null;
                        continue;
                    }
                    actualNode = actualNode.next;
                }
                break block0;
            }
        }
        return authenticationHandler;
    }

    static OncRpcServerAuthSchemes getDefaultRepository() {
        return defaultRepository;
    }

    private class Node {
        OncRpcServerAuthScheme scheme = null;
        Node next = null;

        Node(OncRpcServerAuthScheme authenticationScheme) {
            this.scheme = authenticationScheme;
        }
    }
}

