/*
 * Decompiled with CFR 0.152.
 */
package act.aaa;

import act.Destroyable;
import act.aaa.AAAService;
import act.aaa.ActAAAService;
import act.aaa.DefaultPersistenceService;
import act.app.ActionContext;
import act.app.App;
import act.app.event.AppEventId;
import act.app.event.AppEventListener;
import act.app.event.AppStop;
import act.event.AppEventListenerBase;
import act.util.SessionManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.aaa.AAAPersistentService;
import org.osgl.aaa.Auditor;
import org.osgl.aaa.AuthenticationService;
import org.osgl.aaa.AuthorizationService;
import org.osgl.aaa.Principal;
import org.osgl.http.H;

public class AAAPlugin
extends SessionManager.Listener
implements Destroyable {
    private ConcurrentMap<App, AAAService> services = new ConcurrentHashMap<App, AAAService>();

    protected void releaseResources() {
        this.services.clear();
    }

    public void buildService(App app, ActAAAService service) {
        AAAService aaa = this.initializeAAAService(app, service);
        if (null == aaa.persistentService) {
            aaa.persistentService = new DefaultPersistenceService(service);
        }
        if (null == aaa.authenticationService) {
            aaa.authenticationService = service;
        }
    }

    public void buildService(App app, AuthenticationService service) {
        AAAService aaa = this.initializeAAAService(app, null);
        aaa.authenticationService = service;
    }

    public void buildService(App app, AuthorizationService service) {
        AAAService aaa = this.initializeAAAService(app, null);
        aaa.authorizationService = service;
    }

    public void buildService(App app, AAAPersistentService service) {
        AAAService aaa = this.initializeAAAService(app, null);
        if (null != aaa.persistentService) {
            if (!DefaultPersistenceService.class.equals(service.getClass())) {
                aaa.persistentService = service;
            }
        } else {
            aaa.persistentService = service;
        }
    }

    public void buildService(App app, Auditor auditor) {
        AAAService aaa = this.initializeAAAService(app, null);
        aaa.auditor = auditor;
    }

    private AAAService initializeAAAService(final App app, ActAAAService appSvc) {
        AAAService svc = (AAAService)((Object)this.services.get(app));
        if (null != svc) {
            return svc;
        }
        svc = null == appSvc ? new AAAService(app) : new AAAService(app, appSvc);
        this.services.put(app, svc);
        app.eventBus().bind(AppEventId.STOP, (AppEventListener)new AppEventListenerBase<AppStop>((CharSequence)"aaa-stop"){

            public void on(AppStop event) {
                AAAPlugin.this.services.remove(app);
            }
        });
        return svc;
    }

    public void sessionResolved(H.Session session, ActionContext context) {
        AAAService service = (AAAService)((Object)this.services.get(context.app()));
        service.sessionResolved(session, context);
    }

    public static interface Listener {
        public void principalResolved(Principal var1, ActionContext var2);
    }
}

