/*
 * Decompiled with CFR 0.152.
 */
package act.aaa;

import act.Act;
import act.aaa.AAAConfig;
import act.aaa.AAAPlugin;
import act.aaa.ActAAAService;
import act.aaa.AnnotationUtil;
import act.aaa.DefaultPersistenceService;
import act.aaa.FastJsonPermissionCodec;
import act.aaa.FastJsonPrivilegeCodec;
import act.app.ActionContext;
import act.app.App;
import act.app.AppServiceBase;
import act.app.conf.AutoConfig;
import act.conf.AppConfig;
import act.conf.ConfLoader;
import act.handler.RequestHandler;
import act.handler.builtin.controller.ActionHandlerInvoker;
import act.handler.builtin.controller.Handler;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.handler.builtin.controller.impl.ReflectedHandlerInvoker;
import act.util.MissingAuthenticationHandler;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.aaa.AAA;
import org.osgl.aaa.AAAContext;
import org.osgl.aaa.AAAObject;
import org.osgl.aaa.AAAPersistentService;
import org.osgl.aaa.Auditor;
import org.osgl.aaa.AuthenticationService;
import org.osgl.aaa.AuthorizationService;
import org.osgl.aaa.NoAuthenticate;
import org.osgl.aaa.NoAuthentication;
import org.osgl.aaa.Permission;
import org.osgl.aaa.Principal;
import org.osgl.aaa.Privilege;
import org.osgl.aaa.RequireAuthenticate;
import org.osgl.aaa.RequireAuthentication;
import org.osgl.aaa.Role;
import org.osgl.aaa.impl.DumbAuditor;
import org.osgl.aaa.impl.SimpleAAAContext;
import org.osgl.aaa.impl.SimpleAuthorizationService;
import org.osgl.aaa.impl.SimplePermission;
import org.osgl.aaa.impl.SimplePrincipal;
import org.osgl.aaa.impl.SimplePrivilege;
import org.osgl.aaa.impl.SimpleRole;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;
import org.yaml.snakeyaml.Yaml;

@AutoConfig(value="aaa")
public class AAAService
extends AppServiceBase<AAAService> {
    public static final boolean ALWAYS_AUTHENTICATE = true;
    public static final String ACL_FILE = "acl.yaml";
    public static final String AAA_AUTH_LIST = "aaa.authenticate.list";
    private List<AAAPlugin.Listener> listeners = C.newList();
    private Set<Object> needsAuthentication = C.newSet();
    private Set<Object> noAuthentication = C.newSet();
    private Set<String> waiveAuthenticateList = C.newSet();
    private Set<String> forceAuthenticateList = C.newSet();
    private boolean allowBasicAuthentication = false;
    private final String sessionKeyUsername;
    AuthenticationService authenticationService;
    AuthorizationService authorizationService;
    AAAPersistentService persistentService;
    Auditor auditor;
    private static final Pattern P_PRINCIPAL = Pattern.compile("(principal|prin|pn|account|acc|a)", 2);
    private static final Pattern P_ROLE = Pattern.compile("(role|ro)", 2);
    private static final Pattern P_PRIVILEGE = Pattern.compile("(privilege|priv|pi)", 2);
    private static final Pattern P_PERMISSION = Pattern.compile("(permission|perm|pe)", 2);

    AAAService(App app) {
        super(app);
        this.loadAuthenticateList();
        this.sessionKeyUsername = app.config().sessionKeyUsername();
        this.authorizationService = new SimpleAuthorizationService();
        this.auditor = DumbAuditor.INSTANCE;
        this.allowBasicAuthentication = app.config().basicAuthenticationEnabled();
        this.postOperations(app);
    }

    AAAService(App app, ActAAAService appSvc) {
        this(app);
        this.persistentService = new DefaultPersistenceService(appSvc);
    }

    private void postOperations(App app) {
        app.jobManager().beforeAppStart(new Runnable(){

            @Override
            public void run() {
                AAAService.this.loadAcl();
                AAAService.this.registerFastJsonConfig();
                AAAService.this.registerDefaultContext();
            }
        });
    }

    private void loadAuthenticateList() {
        ArrayList lines = new ArrayList();
        try {
            Enumeration<URL> systemResources = Act.class.getClassLoader().getResources(AAA_AUTH_LIST);
            while (systemResources.hasMoreElements()) {
                InputStream is = systemResources.nextElement().openStream();
                String s = IO.readContentAsString((InputStream)is);
                lines.addAll(C.listOf((Object[])s.split("[\r\n]+")).filter((Osgl.Function)S.F.startsWith((String)"#").negate()).filter((Osgl.Function)S.F.IS_BLANK.negate()));
            }
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
        for (String s : lines) {
            if (!s.startsWith("-")) continue;
            s = s.substring(1);
            this.waiveAuthenticateList.add(s);
        }
        for (String s : lines) {
            if (s.startsWith("-")) continue;
            if (s.startsWith("+")) {
                this.forceAuthenticateList.add(s.substring(1));
                this.waiveAuthenticateList.remove(s.substring(1));
                continue;
            }
            this.forceAuthenticateList.add(s);
            this.waiveAuthenticateList.remove(s);
        }
    }

    private void loadAcl() {
        URL url = this.app().classLoader().getResource(ACL_FILE);
        if (null != url) {
            App.LOGGER.info("found acl.yaml file...");
            this.loadYaml(url);
        } else {
            App.LOGGER.warn("acl.yaml file not found...");
        }
        String commonData = S.fmt((String)"conf/%s/aaa_init_data.yaml", (Object[])new Object[]{ConfLoader.common()});
        url = this.app().classLoader().getResource(commonData);
        if (null != url) {
            this.loadYaml(url);
        }
        String profileData = S.fmt((String)"conf/%s/aaa_init_data.yaml", (Object[])new Object[]{this.app().profile()});
        url = this.app().classLoader().getResource(profileData);
        if (null != url) {
            this.loadYaml(url);
        }
    }

    protected void releaseResources() {
        this.listeners.clear();
        this.needsAuthentication.clear();
        this.noAuthentication.clear();
    }

    public AAAPersistentService persistentService() {
        return this.persistentService;
    }

    public void sessionResolved(H.Session session, ActionContext context) {
        AAAContext aaaCtx = this.createAAAContext();
        AAA.setContext((AAAContext)aaaCtx);
        Principal p = this.resolvePrincipal(aaaCtx, context);
        this.ensureAuthenticity(p, context);
    }

    public AAAContext createAAAContext() {
        return new SimpleAAAContext(this.authenticationService, this.authorizationService, this.persistentService, this.auditor);
    }

    private Principal resolvePrincipal(AAAContext aaaCtx, ActionContext appCtx) {
        Principal p = null;
        String userName = appCtx.session().get(this.sessionKeyUsername);
        if (S.blank((String)userName)) {
            String user2;
            if (this.allowBasicAuthentication && S.notBlank((String)(user2 = appCtx.req().user()))) {
                String password = appCtx.req().password();
                p = this.authenticationService.authenticate(user2, password);
            }
        } else {
            p = (Principal)this.persistentService.findByName(userName, Principal.class);
        }
        if (null == p) {
            appCtx.session().remove(this.sessionKeyUsername);
        } else {
            aaaCtx.setCurrentPrincipal(p);
        }
        this.firePrincipalResolved(p, appCtx);
        return p;
    }

    private void firePrincipalResolved(Principal p, ActionContext context) {
        int j = this.listeners.size();
        for (int i = 0; i < j; ++i) {
            AAAPlugin.Listener l = this.listeners.get(i);
            l.principalResolved(p, context);
        }
    }

    private void ensureAuthenticity(Principal p, ActionContext ctx) {
        if (S.eq((String)AAAConfig.loginUrl, (String)ctx.req().path())) {
            return;
        }
        RequestHandler h = (RequestHandler)ctx.attribute("__act_handler__");
        if (null == h || !(h instanceof RequestHandlerProxy)) {
            return;
        }
        if (null == p) {
            if (!this.requireAuthenticate((RequestHandlerProxy)h)) {
                return;
            }
            AppConfig config = ctx.config();
            MissingAuthenticationHandler handler = ctx.isAjax() ? config.ajaxMissingAuthenticationHandler() : config.missingAuthenticationHandler();
            throw handler.result(ctx);
        }
    }

    private boolean requireAuthenticate(RequestHandlerProxy handler) {
        if (this.needsAuthentication.contains(handler)) {
            return true;
        }
        if (this.noAuthentication.contains(handler)) {
            return false;
        }
        AuthenticationRequirementSensor sensor = new AuthenticationRequirementSensor();
        try {
            handler.accept((Handler.Visitor)sensor);
        }
        catch (Osgl.Break break_) {
            // empty catch block
        }
        Boolean requireAuthentication = sensor.requireAuthentication;
        if (null == requireAuthentication) {
            requireAuthentication = true;
        }
        if (requireAuthentication.booleanValue()) {
            this.needsAuthentication.add(handler);
        } else {
            this.noAuthentication.add(handler);
        }
        return requireAuthentication;
    }

    private void registerFastJsonConfig() {
        SerializeConfig serializeConfig = SerializeConfig.getGlobalInstance();
        ParserConfig parserConfig = ParserConfig.getGlobalInstance();
        FastJsonPermissionCodec permissionCodec = new FastJsonPermissionCodec(this.persistentService);
        serializeConfig.put(SimplePermission.class, (ObjectSerializer)permissionCodec);
        parserConfig.putDeserializer(SimplePermission.class, (ObjectDeserializer)permissionCodec);
        FastJsonPrivilegeCodec privilegeCodec = new FastJsonPrivilegeCodec(this.persistentService);
        serializeConfig.put(SimplePrivilege.class, (ObjectSerializer)privilegeCodec);
        parserConfig.putDeserializer(SimplePrivilege.class, (ObjectDeserializer)privilegeCodec);
    }

    private void registerDefaultContext() {
        AAA.setDefaultContext((AAAContext)this.createAAAContext());
    }

    void loadYaml(URL url) {
        try {
            String s = IO.readContentAsString((InputStream)url.openStream());
            AAAService.loadYamlContent(s, this.persistentService());
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    static void loadYamlContent(String content, AAAPersistentService store) {
        Yaml yaml = new Yaml();
        AAAService.prepareStore(store);
        Object o = yaml.load(content);
        if (o instanceof Map) {
            Map objects = (Map)$.cast((Object)o);
            for (Object key : objects.keySet()) {
                String name = key.toString().trim();
                AAAService.loadObject(name, objects, store);
            }
        }
    }

    static void loadObject(String key, Map<Object, Map<?, ?>> repo, AAAPersistentService store) {
        Map<?, ?> data = repo.get(key);
        String type = (String)data.get("type");
        if (null == type) {
            type = "principal";
        }
        if (P_PRINCIPAL.matcher(type).matches()) {
            AAAService.loadPrincipal(key, data, store);
        } else if (P_ROLE.matcher(type).matches()) {
            AAAService.loadRole(key, data, store);
        } else if (P_PERMISSION.matcher(type).matches()) {
            AAAService.loadPermission(key, data, store);
        } else if (P_PRIVILEGE.matcher(type).matches()) {
            AAAService.loadPrivilege(key, data, store);
        }
    }

    static void loadPrivilege(String name, Map<?, ?> data, AAAPersistentService store) {
        Privilege p = (Privilege)store.findByName(name, Privilege.class);
        if (null != p ? AAAConfig.ddl.update == false : !AAAConfig.ddl.create) {
            return;
        }
        int lvl = (Integer)data.get("level");
        p = new SimplePrivilege(name, lvl);
        store.save((AAAObject)p);
    }

    static void loadPermission(String name, Map<?, ?> data, AAAPersistentService store) {
        Permission p = (Permission)store.findByName(name, Permission.class);
        if (null != p ? AAAConfig.ddl.update == false : !AAAConfig.ddl.create) {
            return;
        }
        boolean dyna = data.containsKey("dynamic") ? (Boolean)data.get("dynamic") : false;
        SimplePermission.Builder builder = new SimplePermission.Builder(name);
        builder.dynamic(dyna);
        List sl = (List)data.get("implied");
        if (null != sl) {
            for (String s0 : sl) {
                Permission perm = (Permission)store.findByName(s0, Permission.class);
                E.invalidConfigurationIf((null == perm ? 1 : 0) != 0, (String)"Cannot find implied permission[%s] when loading permission[%s]", (Object[])new Object[]{s0, name});
                builder.addImplied(perm);
            }
        }
        store.save((AAAObject)builder.toPermission());
    }

    static void loadRole(String name, Map<?, ?> mm, AAAPersistentService store) {
        Role r = (Role)store.findByName(name, Role.class);
        if (null != r ? AAAConfig.ddl.update == false : !AAAConfig.ddl.create) {
            return;
        }
        SimpleRole.Builder builder = new SimpleRole.Builder(name);
        List sl = (List)mm.get("permissions");
        if (null != sl) {
            for (String s0 : sl) {
                Permission perm = (Permission)store.findByName(s0, Permission.class);
                E.invalidConfigurationIf((null == perm ? 1 : 0) != 0, (String)"Cannot find permission[%s] when loading principal[%s]", (Object[])new Object[]{s0, name});
                builder.grantPermission(perm);
            }
        }
        store.save((AAAObject)builder.toRole());
    }

    static void loadPrincipal(String name, Map<?, ?> mm, AAAPersistentService store) {
        List sl;
        Principal p = (Principal)store.findByName(name, Principal.class);
        if (null != p ? AAAConfig.ddl.principal.update == false : !AAAConfig.ddl.principal.create) {
            return;
        }
        SimplePrincipal.Builder builder = new SimplePrincipal.Builder(name);
        String s = (String)mm.get("privilege");
        if (null != s) {
            Privilege priv = (Privilege)store.findByName(s, Privilege.class);
            E.invalidConfigurationIf((null == priv ? 1 : 0) != 0, (String)"Cannot find privilege[%s] when loading principal[%s]", (Object[])new Object[]{s, name});
            builder.grantPrivilege(priv);
        }
        if (null != (sl = (List)mm.get("roles"))) {
            for (String s0 : sl) {
                Role role = (Role)store.findByName(s0, Role.class);
                E.invalidConfigurationIf((null == role ? 1 : 0) != 0, (String)"Cannot find role[%s] when loading principal[%s]", (Object[])new Object[]{s0, name});
                builder.grantRole(role);
            }
        }
        if (null != (sl = (List)mm.get("permissions"))) {
            for (String s0 : sl) {
                Permission perm = (Permission)store.findByName(s0, Permission.class);
                E.invalidConfigurationIf((null == perm ? 1 : 0) != 0, (String)"Cannot find permission[%s] when loading principal[%s]", (Object[])new Object[]{s0, name});
                builder.grantPermission(perm);
            }
        }
        store.save((AAAObject)builder.toPrincipal());
    }

    static void prepareStore(AAAPersistentService store) {
        if (AAAConfig.ddl.delete) {
            store.removeAll(Privilege.class);
            store.removeAll(Permission.class);
            store.removeAll(Role.class);
        }
        if (AAAConfig.ddl.principal.delete) {
            store.removeAll(Principal.class);
        }
    }

    private class AuthenticationRequirementSensor
    implements Handler.Visitor,
    ReflectedHandlerInvoker.ReflectedHandlerInvokerVisitor {
        Boolean requireAuthentication = null;

        private AuthenticationRequirementSensor() {
        }

        public ActionHandlerInvoker.Visitor invokerVisitor() {
            return this;
        }

        private boolean hasAnnotation(Class<? extends Annotation> a, Class<?> c, Method m) {
            return null != AnnotationUtil.findAnnotation(c, a) || null != AnnotationUtil.findAnnotation(m, a);
        }

        public Void apply(Class<?> clazz, Method method) throws NotAppliedException, Osgl.Break {
            if (this.hasAnnotation(RequireAuthentication.class, clazz, method) || this.hasAnnotation(RequireAuthenticate.class, clazz, method)) {
                this.requireAuthentication = true;
                throw $.breakOut((Object)true);
            }
            if (this.hasAnnotation(NoAuthentication.class, clazz, method) || this.hasAnnotation(NoAuthenticate.class, clazz, method)) {
                this.requireAuthentication = false;
                throw $.breakOut((Object)true);
            }
            String actionName = S.builder((String)clazz.getName()).append(".").append(method.getName()).toString();
            if (AAAService.this.forceAuthenticateList.contains(actionName)) {
                this.requireAuthentication = true;
                throw $.breakOut((Object)true);
            }
            if (AAAService.this.waiveAuthenticateList.contains(actionName)) {
                this.requireAuthentication = false;
                throw $.breakOut((Object)true);
            }
            for (String s : AAAService.this.forceAuthenticateList) {
                if (!actionName.startsWith(s) && !actionName.matches(s)) continue;
                this.requireAuthentication = true;
                throw $.breakOut((Object)true);
            }
            for (String s : AAAService.this.waiveAuthenticateList) {
                if (!actionName.startsWith(s) && !actionName.matches(s)) continue;
                this.requireAuthentication = false;
                throw $.breakOut((Object)true);
            }
            return null;
        }
    }
}

