/*
 * Decompiled with CFR 0.152.
 */
package act.aaa;

import act.aaa.ActAAAService;
import act.util.DestroyableBase;
import java.util.Map;
import java.util.Set;
import org.osgl.aaa.AAAObject;
import org.osgl.aaa.AAAPersistentService;
import org.osgl.aaa.Permission;
import org.osgl.aaa.Principal;
import org.osgl.aaa.Privilege;
import org.osgl.aaa.Role;
import org.osgl.util.C;
import org.osgl.util.E;

public class DefaultPersistenceService
extends DestroyableBase
implements AAAPersistentService {
    private ActAAAService actAAAService;
    private Map<String, Role> roles = C.newMap((Object[])new Object[0]);
    private Map<String, Permission> permissions = C.newMap((Object[])new Object[0]);
    private Map<String, Privilege> privileges = C.newMap((Object[])new Object[0]);

    public DefaultPersistenceService(ActAAAService ActAAAService2) {
        E.NPE((Object)ActAAAService2);
        this.actAAAService = ActAAAService2;
    }

    protected void releaseResources() {
        this.roles.clear();
        this.permissions.clear();
        this.privileges.clear();
        this.actAAAService = null;
    }

    public <T extends AAAObject> void removeAll(Class<T> aClass) {
        if (Principal.class.isAssignableFrom(aClass)) {
            this.actAAAService.removeAllPrincipals();
        } else if (Role.class.isAssignableFrom(aClass)) {
            this.roles.clear();
        } else if (Permission.class.isAssignableFrom(aClass)) {
            this.permissions.clear();
        } else if (Privilege.class.isAssignableFrom(aClass)) {
            this.privileges.clear();
        } else {
            throw E.unsupport((String)"Unknown aaa object type: %s", (Object[])new Object[]{aClass});
        }
    }

    public void save(AAAObject aaaObject) {
        if (aaaObject instanceof Principal) {
            this.actAAAService.save((Principal)aaaObject);
        } else if (aaaObject instanceof Role) {
            this.roles.put(aaaObject.getName(), (Role)aaaObject);
        } else if (aaaObject instanceof Permission) {
            this.permissions.put(aaaObject.getName(), (Permission)aaaObject);
        } else if (aaaObject instanceof Privilege) {
            this.privileges.put(aaaObject.getName(), (Privilege)aaaObject);
        } else {
            throw E.unsupport((String)"Unknown aaa object type: %s", (Object[])new Object[]{aaaObject.getClass()});
        }
    }

    public void remove(AAAObject aaaObject) {
        throw E.unsupport();
    }

    public <T extends AAAObject> T findByName(String name, Class<T> aClass) {
        if (Principal.class.isAssignableFrom(aClass)) {
            return (T)this.actAAAService.findByName(name);
        }
        if (Role.class.isAssignableFrom(aClass)) {
            return (T)((AAAObject)this.roles.get(name));
        }
        if (Permission.class.isAssignableFrom(aClass)) {
            return (T)((AAAObject)this.permissions.get(name));
        }
        if (Privilege.class.isAssignableFrom(aClass)) {
            return (T)((AAAObject)this.privileges.get(name));
        }
        throw E.unsupport((String)"Unknown aaa object type: %s", (Object[])new Object[]{aClass});
    }

    public Privilege findPrivilege(int level) {
        for (Privilege p : this.privileges.values()) {
            if (p.getLevel() != level) continue;
            return p;
        }
        return null;
    }

    public Set<String> roleNames() {
        return this.roles.keySet();
    }

    public Set<String> privilegeNames() {
        return this.privileges.keySet();
    }

    public Set<String> permissionNames() {
        return this.permissions.keySet();
    }
}

