/*
 * Decompiled with CFR 0.152.
 */
package act.aaa;

import act.Act;
import act.aaa.AAAPlugin;
import act.aaa.ActAAAService;
import act.aaa.DefaultPersistentService;
import act.aaa.DynamicPermissionCheckHelperBase;
import act.app.App;
import act.app.event.AppEventId;
import act.util.SubClassFinder;
import javax.inject.Inject;
import org.osgl.aaa.AAA;
import org.osgl.aaa.AAAPersistentService;
import org.osgl.aaa.Auditor;
import org.osgl.aaa.AuthenticationService;
import org.osgl.aaa.AuthorizationService;
import org.osgl.aaa.DynamicPermissionCheckHelper;
import org.osgl.aaa.impl.DumbAuditor;

public class AAAServiceFinder<T> {
    private App app;

    @Inject
    public AAAServiceFinder(App app) {
        this.app = app;
    }

    @SubClassFinder(callOn=AppEventId.PRE_START)
    public void foundActAAAService(Class<ActAAAService> serviceType) {
        ActAAAService service = (ActAAAService)this.app.getInstance(serviceType);
        this.plugin().buildService(this.app, service);
    }

    @SubClassFinder(callOn=AppEventId.PRE_START)
    public void foundAuditorService(Class<Auditor> auditorClass) {
        if (DumbAuditor.class.equals(auditorClass)) {
            return;
        }
        Auditor auditor = (Auditor)this.app.getInstance(auditorClass);
        this.plugin().buildService(this.app, auditor);
    }

    @SubClassFinder(callOn=AppEventId.PRE_START)
    public void foundAuthenticationService(Class<AuthenticationService> serviceType) {
        if (ActAAAService.class.isAssignableFrom(serviceType)) {
            return;
        }
        AuthenticationService service = (AuthenticationService)this.app.getInstance(serviceType);
        this.plugin().buildService(this.app, service);
    }

    @SubClassFinder(callOn=AppEventId.PRE_START)
    public void foundAuthorizationService(Class<AuthorizationService> serviceType) {
        AuthorizationService service = (AuthorizationService)this.app.getInstance(serviceType);
        this.plugin().buildService(this.app, service);
    }

    @SubClassFinder(callOn=AppEventId.PRE_START)
    public void foundDynamicPermissionCheckHelper(Class<DynamicPermissionCheckHelperBase> target) {
        DynamicPermissionCheckHelperBase helper = (DynamicPermissionCheckHelperBase)this.app.getInstance(target);
        AAA.registerDynamicPermissionChecker((DynamicPermissionCheckHelper)helper, helper.getTargetClass());
    }

    @SubClassFinder
    public void handleFound(Class<AAAPersistentService> serviceType) {
        if (DefaultPersistentService.class.equals(serviceType)) {
            return;
        }
        AAAPersistentService service = (AAAPersistentService)this.app.getInstance(serviceType);
        this.plugin().buildService(this.app, service);
    }

    private AAAPlugin plugin() {
        return (AAAPlugin)((Object)Act.getInstance(AAAPlugin.class));
    }
}

