/*
 * Decompiled with CFR 0.152.
 */
package act.aaa;

import act.Act;
import act.aaa.AAAService;
import act.aaa.ActAAAService;
import act.aaa.DefaultPersistentService;
import act.aaa.RenderInitHtml;
import act.app.ActionContext;
import act.app.App;
import act.app.event.AppStop;
import act.app.event.SysEventId;
import act.app.event.SysEventListener;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.event.EventBus;
import act.event.SysEventListenerBase;
import act.util.DestroyableBase;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.aaa.AAAPersistentService;
import org.osgl.aaa.Auditor;
import org.osgl.aaa.AuthenticationService;
import org.osgl.aaa.AuthorizationService;
import org.osgl.aaa.Principal;
import org.osgl.http.H;
import org.osgl.util.E;
import osgl.version.Version;

@Singleton
public class AAAPlugin
extends DestroyableBase {
    public static final Version VERSION = Version.of(AAAPlugin.class);
    private ConcurrentMap<App, AAAService> services = new ConcurrentHashMap<App, AAAService>();

    @Inject
    public AAAPlugin(EventBus eventBus) {
        eventBus.bind(ActionContext.PreFireSessionResolvedEvent.class, (ActEventListener)new ActEventListenerBase<ActionContext.PreFireSessionResolvedEvent>(){

            public void on(ActionContext.PreFireSessionResolvedEvent event) {
                ActionContext context = (ActionContext)event.source();
                H.Session session = event.session();
                AAAService service = (AAAService)((Object)AAAPlugin.this.services.get(context.app()));
                if (Act.isDev() && !service.serviceInitialized()) {
                    throw (RenderInitHtml)((Object)Act.getInstance(RenderInitHtml.class));
                }
                service.sessionResolved(session, context);
            }
        });
    }

    protected void releaseResources() {
        this.services.clear();
    }

    public void buildService(App app, ActAAAService service) {
        AAAService aaa = this.initializeAAAService(app, service);
        if (null == aaa.persistentService()) {
            aaa.persistentService(new DefaultPersistentService(service));
            aaa.persistentService();
        }
        if (null == aaa.authenticationService()) {
            aaa.authenticationService(service);
        }
    }

    public void buildService(App app, AuthenticationService service) {
        AAAService aaa = this.initializeAAAService(app, null);
        aaa.authenticationService(service);
    }

    public void buildService(App app, AuthorizationService service) {
        AAAService aaa = this.initializeAAAService(app, null);
        aaa.authorizationService(service);
    }

    public void buildService(App app, AAAPersistentService service) {
        E.NPE((Object)service);
        AAAService aaa = this.initializeAAAService(app, null);
        aaa.persistentService(service);
    }

    public void buildService(App app, Auditor auditor) {
        AAAService aaa = this.initializeAAAService(app, null);
        aaa.auditor(auditor);
    }

    private AAAService initializeAAAService(final App app, ActAAAService appSvc) {
        AAAService svc = (AAAService)((Object)this.services.get(app));
        if (null != svc) {
            return svc;
        }
        svc = null == appSvc ? new AAAService(app) : new AAAService(app, appSvc);
        this.services.put(app, svc);
        EventBus eventBus = app.eventBus();
        eventBus.bind(SysEventId.STOP, (SysEventListener)new SysEventListenerBase<AppStop>((CharSequence)"aaa-stop"){

            public void on(AppStop event) {
                AAAPlugin.this.services.remove(app);
            }
        });
        return svc;
    }

    public static interface Listener {
        public void principalResolved(Principal var1, ActionContext var2);
    }
}

