/*
 * Decompiled with CFR 0.152.
 */
package act.aaa;

import act.Act;
import act.aaa.AAAConfig;
import act.aaa.AAAPersistenceServiceInitialized;
import act.aaa.AAAPlugin;
import act.aaa.ActAAAService;
import act.aaa.AnnotationUtil;
import act.aaa.AuditorInitialized;
import act.aaa.AuthenticationServiceInitialized;
import act.aaa.AuthorizationServiceInitialized;
import act.aaa.DefaultPersistentService;
import act.aaa.FastJsonPermissionCodec;
import act.aaa.FastJsonPrivilegeCodec;
import act.aaa.PrincipalResolved;
import act.app.ActionContext;
import act.app.App;
import act.app.AppClassLoader;
import act.app.AppServiceBase;
import act.app.ProjectLayout;
import act.app.conf.AutoConfig;
import act.conf.ConfLoader;
import act.event.ActEvent;
import act.event.OnceEventListenerBase;
import act.handler.RequestHandler;
import act.handler.builtin.controller.ActionHandlerInvoker;
import act.handler.builtin.controller.Handler;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.handler.builtin.controller.impl.ReflectedHandlerInvoker;
import act.util.MissingAuthenticationHandler;
import act.util.SubClassFinder;
import act.view.ActForbidden;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.aaa.AAA;
import org.osgl.aaa.AAAContext;
import org.osgl.aaa.AAAObject;
import org.osgl.aaa.AAAPersistentService;
import org.osgl.aaa.Auditor;
import org.osgl.aaa.AuthenticationService;
import org.osgl.aaa.AuthorizationService;
import org.osgl.aaa.NoAccessException;
import org.osgl.aaa.NoAuthenticate;
import org.osgl.aaa.NoAuthentication;
import org.osgl.aaa.Permission;
import org.osgl.aaa.Principal;
import org.osgl.aaa.Privilege;
import org.osgl.aaa.RequireAuthenticate;
import org.osgl.aaa.RequireAuthentication;
import org.osgl.aaa.Role;
import org.osgl.aaa.impl.DumbAuditor;
import org.osgl.aaa.impl.SimpleAAAContext;
import org.osgl.aaa.impl.SimpleAuthorizationService;
import org.osgl.aaa.impl.SimplePermission;
import org.osgl.aaa.impl.SimplePrincipal;
import org.osgl.aaa.impl.SimplePrivilege;
import org.osgl.aaa.impl.SimpleRole;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.mvc.annotation.Catch;
import org.osgl.util.C;
import org.osgl.util.Const;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;
import org.yaml.snakeyaml.Yaml;
import osgl.version.Version;

@AutoConfig(value="aaa")
public class AAAService
extends AppServiceBase<AAAService> {
    public static final Version VERSION = AAAPlugin.VERSION;
    private static final Const<Boolean> ALWAYS_AUTHENTICATE = $.constant((Object)true);
    private static final Const<String> ACL_FILE = $.constant((Object)"acl.yaml");
    private static final String AAA_AUTH_LIST = "aaa.authenticate.list";
    private static final Const<Boolean> ALLOW_SYS_SERVICE_ON_DEV_MODE = $.constant((Object)false);
    private List<AAAPlugin.Listener> listeners = C.newList();
    private Set<Object> needsAuthentication = C.newSet();
    private Set<Object> noAuthentication = C.newSet();
    private Set<String> waiveAuthenticateList = C.newSet();
    private Set<String> forceAuthenticateList = C.newSet();
    private boolean allowBasicAuthentication = false;
    private boolean disabled;
    private final String sessionKeyUsername;
    private AuthenticationService authenticationService;
    private AuthorizationService authorizationService;
    private AAAPersistentService persistentService;
    private Auditor auditor;
    private OnceEventListenerBase onServiceInitialized = new OnceEventListenerBase(){

        public boolean tryHandle(EventObject event) throws Exception {
            if (AAAService.this.serviceInitialized()) {
                AAAService.this.loadAcl();
                AAAService.this.registerFastJsonConfig();
                AAAService.this.registerDefaultContext();
            }
            return true;
        }
    };
    private static final Pattern P_PRINCIPAL = Pattern.compile("(principal|prin|pn|account|acc|a)", 2);
    private static final Pattern P_ROLE = Pattern.compile("(role|ro)", 2);
    private static final Pattern P_PRIVILEGE = Pattern.compile("(privilege|priv|pi)", 2);
    private static final Pattern P_PERMISSION = Pattern.compile("(permission|perm|pe)", 2);

    AAAService(App app) {
        super(app);
        this.loadAuthenticateList();
        this.sessionKeyUsername = app.config().sessionKeyUsername();
        this.authorizationService = new SimpleAuthorizationService();
        this.auditor = DumbAuditor.INSTANCE;
        this.allowBasicAuthentication = app.config().basicAuthenticationEnabled();
        this.postOperations(app);
    }

    AAAService(App app, ActAAAService appSvc) {
        this(app);
        this.persistentService(new DefaultPersistentService(appSvc));
    }

    public boolean serviceInitialized() {
        return null != this.authenticationService && null != this.authorizationService && null != this.persistentService;
    }

    private void postOperations(App app) {
        app.eventBus().once(AAAPersistenceServiceInitialized.class, this.onServiceInitialized);
        app.eventBus().once(AuthenticationServiceInitialized.class, this.onServiceInitialized);
        app.eventBus().once(AuthorizationServiceInitialized.class, this.onServiceInitialized);
    }

    private void loadAuthenticateList() {
        ArrayList lines = new ArrayList();
        try {
            Enumeration<URL> systemResources = Act.class.getClassLoader().getResources(AAA_AUTH_LIST);
            while (systemResources.hasMoreElements()) {
                InputStream is = systemResources.nextElement().openStream();
                String s = IO.readContentAsString((InputStream)is);
                lines.addAll(C.listOf((Object[])s.split("[\r\n]+")).filter((Lang.Function)S.F.startsWith((String)"#").negate()).filter((Lang.Function)S.F.IS_BLANK.negate()));
            }
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
        for (String s : lines) {
            if (!s.startsWith("-")) continue;
            s = s.substring(1);
            this.waiveAuthenticateList.add(s);
        }
        for (String s : lines) {
            if (s.startsWith("-")) continue;
            if (s.startsWith("+")) {
                this.forceAuthenticateList.add(s.substring(1));
                this.waiveAuthenticateList.remove(s.substring(1));
                continue;
            }
            this.forceAuthenticateList.add(s);
            this.waiveAuthenticateList.remove(s);
        }
    }

    private void loadAcl() {
        if (Act.isDev()) {
            this.devLoadAcl();
        } else {
            this.prodLoadAcl();
        }
    }

    private void devLoadAcl() {
        String aclFile = (String)ACL_FILE.get();
        File resources = this.app().layout().resource(this.app().base());
        File acl = ProjectLayout.Utils.file((File)resources, (String)aclFile);
        this.loadYaml(acl);
        File confRoot = ProjectLayout.Utils.file((File)resources, (String)"/conf");
        acl = ProjectLayout.Utils.file((File)confRoot, (String)aclFile);
        this.loadYaml(acl);
        File common = ProjectLayout.Utils.file((File)confRoot, (String)ConfLoader.common());
        acl = ProjectLayout.Utils.file((File)common, (String)aclFile);
        this.loadYaml(acl);
        File profile = ProjectLayout.Utils.file((File)confRoot, (String)Act.profile());
        acl = ProjectLayout.Utils.file((File)profile, (String)aclFile);
        this.loadYaml(acl);
    }

    private void prodLoadAcl() {
        String profileData;
        String commonData;
        URL url = this.app().classLoader().getResource((String)ACL_FILE.get());
        if (null != url) {
            this.loadYaml(url);
        }
        AppClassLoader classLoader = this.app().classLoader();
        String confData = S.fmt((String)"conf/%s", (Object[])new Object[]{ACL_FILE});
        url = classLoader.getResource(confData);
        if (null != url) {
            this.loadYaml(url);
        }
        if (null != (url = classLoader.getResource(commonData = S.fmt((String)"conf/%s/%s", (Object[])new Object[]{ConfLoader.common(), ACL_FILE})))) {
            this.loadYaml(url);
        }
        if (null != (url = classLoader.getResource(profileData = S.fmt((String)"conf/%s/%s", (Object[])new Object[]{this.app().profile(), ACL_FILE})))) {
            this.loadYaml(url);
        }
    }

    protected void releaseResources() {
        this.listeners.clear();
        this.needsAuthentication.clear();
        this.noAuthentication.clear();
    }

    public AAAPersistentService persistentService() {
        return this.persistentService;
    }

    public AuthenticationService authenticationService() {
        return this.authenticationService;
    }

    public AuthorizationService authorizationService() {
        return this.authorizationService;
    }

    public Auditor auditor() {
        return this.auditor;
    }

    AAAService persistentService(AAAPersistentService service) {
        boolean firstLoadPersistenceService;
        boolean bl = firstLoadPersistenceService = null == this.persistentService;
        if (null != this.persistentService && service instanceof DefaultPersistentService) {
            return this;
        }
        this.persistentService = (AAAPersistentService)$.notNull((Object)service);
        if (firstLoadPersistenceService) {
            this.app().eventBus().trigger((ActEvent)new AAAPersistenceServiceInitialized(this), new Object[0]);
        }
        return this;
    }

    AAAService authenticationService(AuthenticationService service) {
        boolean firstLoad = null == this.authenticationService;
        this.authenticationService = (AuthenticationService)$.notNull((Object)service);
        if (firstLoad) {
            this.app().eventBus().trigger((ActEvent)new AuthenticationServiceInitialized(this), new Object[0]);
        }
        return this;
    }

    AAAService authorizationService(AuthorizationService service) {
        boolean firstLoad = null == this.authorizationService;
        this.authorizationService = (AuthorizationService)$.notNull((Object)service);
        if (firstLoad) {
            this.app().eventBus().trigger((ActEvent)new AuthorizationServiceInitialized(this), new Object[0]);
        }
        return this;
    }

    AAAService auditor(Auditor auditor) {
        boolean firstLoad = null == this.auditor;
        this.auditor = (Auditor)$.notNull((Object)auditor);
        if (firstLoad) {
            this.app().eventBus().trigger((ActEvent)new AuditorInitialized(this), new Object[0]);
        }
        return this;
    }

    public void sessionResolved(H.Session session, ActionContext context) {
        if (this.disabled) {
            return;
        }
        AAAContext aaaCtx = this.createAAAContext();
        AAA.setContext((AAAContext)aaaCtx);
        try {
            Principal p = this.resolvePrincipal(aaaCtx, context);
            this.ensureAuthenticity(p, context);
        }
        catch (NoAccessException e) {
            throw ActForbidden.create((Throwable)e);
        }
    }

    public AAAContext createAAAContext() {
        return new SimpleAAAContext(this.authenticationService, this.authorizationService, this.persistentService, this.auditor);
    }

    private Principal resolvePrincipal(AAAContext aaaCtx, ActionContext appCtx) {
        Principal p = null;
        String userName = appCtx.session().get(this.sessionKeyUsername);
        if (S.blank((String)userName)) {
            String user2;
            if (this.allowBasicAuthentication && S.notBlank((String)(user2 = appCtx.req().user()))) {
                String password = appCtx.req().password();
                p = this.authenticationService.authenticate(user2, password);
            }
        } else {
            p = (Principal)this.persistentService.findByName(userName, Principal.class);
        }
        if (null == p) {
            appCtx.session().remove(this.sessionKeyUsername);
        } else {
            aaaCtx.setCurrentPrincipal(p);
        }
        this.firePrincipalResolved(p, appCtx);
        return p;
    }

    private void firePrincipalResolved(Principal p, ActionContext context) {
        int j = this.listeners.size();
        for (int i = 0; i < j; ++i) {
            AAAPlugin.Listener l = this.listeners.get(i);
            l.principalResolved(p, context);
        }
        if (null != p) {
            context.app().eventBus().trigger((ActEvent)new PrincipalResolved(p), new Object[0]);
        }
    }

    private void ensureAuthenticity(Principal p, ActionContext ctx) {
        if (S.eq((String)AAAConfig.loginUrl, (String)ctx.req().path())) {
            return;
        }
        RequestHandler h = ctx.handler();
        if (null == h || h.sessionFree()) {
            return;
        }
        if (null == p) {
            if (!this.requireAuthenticate(h)) {
                return;
            }
            MissingAuthenticationHandler handler = ctx.missingAuthenticationHandler();
            handler.handle(ctx);
        }
    }

    private boolean requireAuthenticate(RequestHandler handler) {
        if (this.needsAuthentication.contains(handler)) {
            return true;
        }
        if (this.noAuthentication.contains(handler)) {
            return false;
        }
        if (!(handler instanceof RequestHandlerProxy)) {
            String actionName = handler.getClass().getName();
            boolean needAuthentication = this.requireAuthentication(actionName);
            if (needAuthentication) {
                this.needsAuthentication.add(handler);
            } else {
                this.noAuthentication.add(handler);
            }
            return needAuthentication;
        }
        AuthenticationRequirementSensor sensor = new AuthenticationRequirementSensor();
        try {
            ((RequestHandlerProxy)handler).accept((Handler.Visitor)sensor);
        }
        catch (Lang.Break needAuthentication) {
            // empty catch block
        }
        boolean requireAuthentication = sensor.requireAuthentication;
        if (requireAuthentication) {
            this.needsAuthentication.add(handler);
        } else {
            this.noAuthentication.add(handler);
        }
        return requireAuthentication;
    }

    private boolean requireAuthentication(String actionName) {
        if (this.forceAuthenticateList.contains(actionName)) {
            return true;
        }
        if (this.waiveAuthenticateList.contains(actionName)) {
            return false;
        }
        for (String s : this.forceAuthenticateList) {
            if (!actionName.startsWith(s) && !actionName.matches(s)) continue;
            return true;
        }
        for (String s : this.waiveAuthenticateList) {
            if (!actionName.startsWith(s) && !actionName.matches(s)) continue;
            return false;
        }
        return (Act.isProd() || (Boolean)ALLOW_SYS_SERVICE_ON_DEV_MODE.get() == false) && (Boolean)ALWAYS_AUTHENTICATE.get() != false;
    }

    private void registerFastJsonConfig() {
        SerializeConfig serializeConfig = SerializeConfig.getGlobalInstance();
        ParserConfig parserConfig = ParserConfig.getGlobalInstance();
        FastJsonPermissionCodec permissionCodec = new FastJsonPermissionCodec(this.persistentService);
        serializeConfig.put(SimplePermission.class, (ObjectSerializer)permissionCodec);
        parserConfig.putDeserializer(SimplePermission.class, (ObjectDeserializer)permissionCodec);
        FastJsonPrivilegeCodec privilegeCodec = new FastJsonPrivilegeCodec(this.persistentService);
        serializeConfig.put(SimplePrivilege.class, (ObjectSerializer)privilegeCodec);
        parserConfig.putDeserializer(SimplePrivilege.class, (ObjectDeserializer)privilegeCodec);
    }

    private void registerDefaultContext() {
        try {
            AAA.setDefaultContext((AAAContext)this.createAAAContext());
        }
        catch (NullPointerException e) {
            this.warn("Cannot create AAA context. AAA plugin disabled", new Object[0]);
            this.disabled = true;
        }
    }

    void loadYaml(URL url) {
        try {
            String s = IO.readContentAsString((InputStream)url.openStream());
            AAAService.loadYamlContent(s, this.persistentService());
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    void loadYaml(File file) {
        if (file.exists() && file.canRead()) {
            AAAService.loadYamlContent(IO.readContentAsString((File)file), this.persistentService());
        }
    }

    static void loadYamlContent(String content, AAAPersistentService store) {
        Yaml yaml = new Yaml();
        AAAService.prepareStore(store);
        Object o = yaml.load(content);
        if (o instanceof Map) {
            Map objects = (Map)$.cast((Object)o);
            for (Object key : objects.keySet()) {
                String name = key.toString().trim();
                AAAService.loadObject(name, objects, store);
            }
        }
    }

    static void loadObject(String key, Map<Object, Map<?, ?>> repo, AAAPersistentService store) {
        Map<?, ?> data = repo.get(key);
        String type = (String)data.get("type");
        if (null == type) {
            type = "principal";
        }
        if (P_PRINCIPAL.matcher(type).matches()) {
            AAAService.loadPrincipal(key, data, store);
        } else if (P_ROLE.matcher(type).matches()) {
            AAAService.loadRole(key, data, store);
        } else if (P_PERMISSION.matcher(type).matches()) {
            AAAService.loadPermission(key, data, store);
        } else if (P_PRIVILEGE.matcher(type).matches()) {
            AAAService.loadPrivilege(key, data, store);
        }
    }

    static void loadPrivilege(String name, Map<?, ?> data, AAAPersistentService store) {
        Privilege p = (Privilege)store.findByName(name, Privilege.class);
        if (null != p ? AAAConfig.ddl.update == false : !AAAConfig.ddl.create) {
            return;
        }
        int lvl = (Integer)data.get("level");
        p = new SimplePrivilege(name, lvl);
        store.save((AAAObject)p);
    }

    static void loadPermission(String name, Map<?, ?> data, AAAPersistentService store) {
        Permission p = (Permission)store.findByName(name, Permission.class);
        if (null != p ? AAAConfig.ddl.update == false : !AAAConfig.ddl.create) {
            return;
        }
        boolean dyna = data.containsKey("dynamic") ? (Boolean)data.get("dynamic") : false;
        SimplePermission.Builder builder = new SimplePermission.Builder(name);
        builder.dynamic(dyna);
        List sl = (List)data.get("implied");
        if (null != sl) {
            for (String s0 : sl) {
                Permission perm = (Permission)store.findByName(s0, Permission.class);
                E.invalidConfigurationIf((null == perm ? 1 : 0) != 0, (String)"Cannot find implied permission[%s] when loading permission[%s]", (Object[])new Object[]{s0, name});
                builder.addImplied(perm);
            }
        }
        store.save((AAAObject)builder.toPermission());
    }

    static void loadRole(String name, Map<?, ?> mm, AAAPersistentService store) {
        Role r = (Role)store.findByName(name, Role.class);
        if (null != r ? AAAConfig.ddl.update == false : !AAAConfig.ddl.create) {
            return;
        }
        SimpleRole.Builder builder = new SimpleRole.Builder(name);
        List sl = (List)mm.get("permissions");
        if (null != sl) {
            for (String s0 : sl) {
                Permission perm = (Permission)store.findByName(s0, Permission.class);
                E.invalidConfigurationIf((null == perm ? 1 : 0) != 0, (String)"Cannot find permission[%s] when loading principal[%s]", (Object[])new Object[]{s0, name});
                builder.grantPermission(perm);
            }
        }
        store.save((AAAObject)builder.toRole());
    }

    static void loadPrincipal(String name, Map<?, ?> mm, AAAPersistentService store) {
        List sl;
        Principal p = (Principal)store.findByName(name, Principal.class);
        if (null != p ? AAAConfig.ddl.principal.update == false : !AAAConfig.ddl.principal.create) {
            return;
        }
        SimplePrincipal.Builder builder = new SimplePrincipal.Builder(name);
        String s = (String)mm.get("privilege");
        if (null != s) {
            Privilege priv = (Privilege)store.findByName(s, Privilege.class);
            E.invalidConfigurationIf((null == priv ? 1 : 0) != 0, (String)"Cannot find privilege[%s] when loading principal[%s]", (Object[])new Object[]{s, name});
            builder.grantPrivilege(priv);
        }
        if (null != (sl = (List)mm.get("roles"))) {
            for (String s0 : sl) {
                Role role = (Role)store.findByName(s0, Role.class);
                E.invalidConfigurationIf((null == role ? 1 : 0) != 0, (String)"Cannot find role[%s] when loading principal[%s]", (Object[])new Object[]{s0, name});
                builder.grantRole(role);
            }
        }
        if (null != (sl = (List)mm.get("permissions"))) {
            for (String s0 : sl) {
                Permission perm = (Permission)store.findByName(s0, Permission.class);
                E.invalidConfigurationIf((null == perm ? 1 : 0) != 0, (String)"Cannot find permission[%s] when loading principal[%s]", (Object[])new Object[]{s0, name});
                builder.grantPermission(perm);
            }
        }
        store.save((AAAObject)builder.toPrincipal());
    }

    static void prepareStore(AAAPersistentService store) {
        if (AAAConfig.ddl.delete) {
            store.removeAll(Privilege.class);
            store.removeAll(Permission.class);
            store.removeAll(Role.class);
        }
        if (AAAConfig.ddl.principal.delete) {
            store.removeAll(Principal.class);
        }
    }

    @SubClassFinder
    void loadListener(AAAPlugin.Listener listener) {
        this.listeners.add(listener);
    }

    private class AuthenticationRequirementSensor
    implements Handler.Visitor,
    ReflectedHandlerInvoker.ReflectedHandlerInvokerVisitor {
        boolean requireAuthentication = false;

        private AuthenticationRequirementSensor() {
        }

        public ActionHandlerInvoker.Visitor invokerVisitor() {
            return this;
        }

        private boolean hasAnnotation(Class<? extends Annotation> a, Class<?> c, Method m) {
            return null != AnnotationUtil.findAnnotation(c, a) || null != AnnotationUtil.findAnnotation(m, a);
        }

        public Void apply(Class<?> clazz, Method method) throws NotAppliedException, Lang.Break {
            if (null != method.getAnnotation(Catch.class)) {
                return null;
            }
            if (this.hasAnnotation(RequireAuthentication.class, clazz, method) || this.hasAnnotation(RequireAuthenticate.class, clazz, method)) {
                this.requireAuthentication = true;
                throw $.breakOut((Object)true);
            }
            if (this.hasAnnotation(NoAuthentication.class, clazz, method) || this.hasAnnotation(NoAuthenticate.class, clazz, method)) {
                return null;
            }
            String actionName = S.builder((String)clazz.getName()).append(".").append(method.getName()).toString();
            this.requireAuthentication = AAAService.this.requireAuthentication(actionName);
            if (this.requireAuthentication) {
                throw $.breakOut((Object)true);
            }
            return null;
        }
    }
}

