/*
 * Decompiled with CFR 0.152.
 */
package act.aaa;

import act.Act;
import act.aaa.AAAConfig;
import act.app.event.SysEventId;
import act.db.Dao;
import act.util.SingletonBase;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.aaa.AAAPersistentService;
import org.osgl.aaa.AuthenticationService;
import org.osgl.aaa.Permission;
import org.osgl.aaa.Principal;
import org.osgl.aaa.Role;
import org.osgl.aaa.impl.SimplePrincipal;
import org.osgl.cache.CacheService;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Generics;
import org.osgl.util.S;

public interface ActAAAService
extends AuthenticationService {
    public void save(Principal var1);

    public void removeAllPrincipals();

    public Principal findByName(String var1);

    public static abstract class Base<USER_TYPE>
    extends SingletonBase
    implements ActAAAService {
        protected Logger logger = LogManager.get(this.getClass());
        protected Class<USER_TYPE> userType;
        private boolean userTypeIsPrincipal;
        protected Dao<?, USER_TYPE, ?> userDao;
        @Inject
        private CacheService cacheService;
        @Inject
        private Provider<AAAPersistentService> persistentServiceProvider;

        public Base() {
            List typeParams = Generics.typeParamImplementations(this.getClass(), Base.class);
            this.initUserType((Class)typeParams.get(0));
        }

        public Base(Class<USER_TYPE> userType) {
            this.initUserType(userType);
        }

        @Override
        public void save(Principal principal2) {
            throw E.unsupport();
        }

        @Override
        public void removeAllPrincipals() {
            throw E.unsupport();
        }

        @Override
        public Principal findByName(String name) {
            USER_TYPE user2 = this.findUser(name);
            return null == user2 ? null : this.principalOf(user2);
        }

        public Principal authenticate(String username, String password) {
            USER_TYPE user2 = this.findUser(username);
            return null == user2 ? null : (this.verifyPassword(user2, password.toCharArray()) ? this.principalOf(user2) : null);
        }

        public Principal authenticate(String username, char[] password) {
            USER_TYPE user2 = this.findUser(username);
            return null == user2 ? null : (this.verifyPassword(user2, password) ? this.principalOf(user2) : null);
        }

        protected String userKey() {
            return null;
        }

        protected Principal principalOf(USER_TYPE user2) {
            if (this.userTypeIsPrincipal) {
                return (Principal)user2;
            }
            return this.buildPrincipalFrom(user2);
        }

        private Principal buildPrincipalFrom(USER_TYPE user2) {
            SimplePrincipal.Builder pb = new SimplePrincipal.Builder(this.username(user2));
            AAAPersistentService store = (AAAPersistentService)this.persistentServiceProvider.get();
            Integer I = this.privilegeOf(user2);
            if (null != I) {
                pb.grantPrivilege(store.findPrivilege(I.intValue()));
            }
            for (String role : this.rolesOf(user2)) {
                pb.grantRole((Role)store.findByName(role, Role.class));
            }
            for (String perm : this.permissionsOf(user2)) {
                pb.grantPermission((Permission)store.findByName(perm, Permission.class));
            }
            SimplePrincipal principal2 = pb.toPrincipal();
            this.setPrincipalProperties((Principal)principal2, user2);
            return principal2;
        }

        protected String username(USER_TYPE user2) {
            return (String)$.getProperty((CacheService)this.cacheService, user2, (String)this._userKey());
        }

        @Deprecated
        protected String nameOf(USER_TYPE user2) {
            return this.username(user2);
        }

        protected Integer privilegeOf(USER_TYPE user2) {
            return null;
        }

        protected Set<String> rolesOf(USER_TYPE user2) {
            return C.set();
        }

        protected Set<String> permissionsOf(USER_TYPE user2) {
            return C.set();
        }

        protected void setPrincipalProperties(Principal principal2, USER_TYPE user2) {
        }

        protected abstract boolean verifyPassword(USER_TYPE var1, char[] var2);

        protected USER_TYPE findUser(String username) {
            if (username.contains(":")) {
                String field = S.beforeFirst((String)username, (String)":");
                String value = S.afterFirst((String)username, (String)":");
                return (USER_TYPE)this.userDao.findOneBy(field, new Object[]{value});
            }
            return (USER_TYPE)this.userDao.findOneBy(this._userKey(), new Object[]{username});
        }

        private String _userKey() {
            return (String)AAAConfig.user.key.get();
        }

        protected void initUserType(Class<USER_TYPE> userType) {
            this.cacheService = Act.cache();
            this.userType = (Class)$.notNull(userType);
            this.userTypeIsPrincipal = Principal.class.isAssignableFrom(userType);
            String userKey = this.userKey();
            if (S.notBlank((String)userKey)) {
                $.setProperty(AAAConfig.user.key, (Object)userKey, (String)"v");
            }
            this.initUserDao(userType);
        }

        protected void initUserDao(final Class<USER_TYPE> userType) {
            Act.app().jobManager().on(SysEventId.DB_SVC_LOADED, new Runnable(){

                @Override
                public void run() {
                    Base.this.userDao = Act.app().dbServiceManager().dao(userType);
                }
            });
        }
    }
}

