/*
 * Decompiled with CFR 0.152.
 */
package act.view.beetl;

import act.Act;
import act.view.TemplateBase;
import act.view.beetl.BeetlTemplateException;
import act.view.beetl.BeetlView;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.osgl.http.H;
import org.osgl.util.IO;
import org.osgl.util.S;

public class BeetlTemplate
extends TemplateBase {
    private static StringTemplateResourceLoader STRING_TEMPLATE_RESOURCE_LOADER = new StringTemplateResourceLoader();
    private boolean inline;
    private String resourcePath;
    private BeetlView view;

    BeetlTemplate(String resourcePath, BeetlView view) {
        this(resourcePath, view, false);
    }

    BeetlTemplate(String resourcePath, BeetlView view, boolean inline) {
        this.resourcePath = S.requireNotBlank((String)resourcePath);
        this.view = view;
        this.inline = inline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void merge(Map<String, Object> renderArgs, H.Response response) {
        if (Act.isDev()) {
            super.merge(renderArgs, response);
            return;
        }
        Template beetlTemplate = this.getTemplate();
        beetlTemplate.binding(renderArgs);
        this.view.templateModifier.apply((Object)beetlTemplate);
        if (this.view.directByteOutput) {
            OutputStream os = response.outputStream();
            try {
                beetlTemplate.renderTo(response.outputStream());
            }
            finally {
                IO.close((Closeable)os);
            }
        }
        Writer writer = response.writer();
        try {
            beetlTemplate.renderTo(writer);
        }
        finally {
            IO.close((Closeable)writer);
        }
    }

    protected String render(Map<String, Object> renderArgs) {
        Thread t0 = Thread.currentThread();
        ClassLoader loader0 = t0.getContextClassLoader();
        try {
            Template beetlTemplate = this.getTemplate();
            t0.setContextClassLoader((ClassLoader)Act.app().classLoader());
            beetlTemplate.binding(renderArgs);
            this.view.templateModifier.apply((Object)beetlTemplate);
            String string = beetlTemplate.render();
            return string;
        }
        catch (BeetlException be) {
            throw new BeetlTemplateException(be);
        }
        finally {
            t0.setContextClassLoader(loader0);
        }
    }

    private Template getTemplate() {
        return this.inline ? this.view.beetl.getTemplate(this.resourcePath, (ResourceLoader)STRING_TEMPLATE_RESOURCE_LOADER) : this.view.beetl.getTemplate(this.resourcePath);
    }
}

