/*
 * Decompiled with CFR 0.152.
 */
package act.view.beetl;

import act.app.SourceInfo;
import act.view.TemplateException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.input.ReaderInputStream;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.ErrorInfo;
import org.osgl.util.C;
import org.osgl.util.IO;
import org.osgl.util.S;

public class BeetlTemplateException
extends TemplateException {
    private ErrorInfo errorInfo;
    private BeetlException beetlException;

    public BeetlTemplateException(BeetlException t) {
        super((Exception)t);
    }

    protected void populateSourceInfo(Throwable t0) {
        BeetlException t;
        this.beetlException = t = (BeetlException)t0;
        this.errorInfo = new ErrorInfo(t);
        this.templateInfo = new BeetlSourceInfo(this.beetlException, this.errorInfo);
        if (this.isNativeException()) {
            this.sourceInfo = BeetlTemplateException.getJavaSourceInfo((Throwable)t.getCause());
        }
    }

    public List<String> stackTrace() {
        return this.isNativeException() ? super.stackTrace() : C.list();
    }

    public String errorMessage() {
        String msg;
        if (this.isNativeException()) {
            for (Throwable cause = this.errorInfo.getCause(); null != cause; cause = cause.getCause()) {
                if (null != cause.getCause()) continue;
                return cause.getMessage();
            }
            return S.concat((String)this.errorInfo.getErrorCode(), (String)": ", (String)this.errorInfo.getMsg());
        }
        StringBuilder sb = new StringBuilder(this.errorInfo.getType());
        String tokenText = this.errorInfo.getErrorTokenText();
        if (S.notBlank((String)tokenText)) {
            sb.append(":<b>").append(this.errorInfo.getErrorTokenText()).append(" </b>");
        }
        if (S.notBlank((String)(msg = this.errorInfo.getMsg()))) {
            sb.append("<br><pre>").append(msg).append("</pre>");
        }
        return sb.toString();
    }

    protected boolean isTemplateEngineInvokeLine(String s) {
        return s.contains("org.beetl.core.om.ObjectUtil.invoke");
    }

    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        if (!traceLine.contains("sun.reflect") && this.isTemplateEngineInvokeLine(nextTraceLine)) {
            return true;
        }
        return super.isErrorSpot(traceLine, nextTraceLine);
    }

    private boolean isNativeException() {
        return this.errorInfo.getErrorCode().startsWith("NATIVE_");
    }

    private static class BeetlSourceInfo
    extends SourceInfo.Base {
        BeetlSourceInfo(BeetlException be, ErrorInfo errorInfo) {
            this.lineNumber = errorInfo.getErrorTokenLine();
            ResourceLoader loader = be.gt.getResourceLoader();
            Resource resource = be.resource;
            String content = IO.readContentAsString((InputStream)new ReaderInputStream(resource.openReader()));
            this.lines = S.notBlank((String)content) ? C.listOf((Object[])content.split("[\n\r]+")) : C.list();
            this.fileName = resource.getId();
        }
    }
}

