/*
 * Decompiled with CFR 0.152.
 */
package act.view.beetl;

import act.Act;
import act.app.App;
import act.app.AppClassLoader;
import act.app.event.SysEventId;
import act.inject.util.ConfigResourceLoader;
import act.util.SubClassFinder;
import act.view.Template;
import act.view.View;
import act.view.beetl.BeetlTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Provider;
import org.beetl.core.Configuration;
import org.beetl.core.DefaultNativeSecurityManager;
import org.beetl.core.Function;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.ext.web.WebRenderExt;
import org.osgl.Lang;
import org.osgl.exception.ConfigurationException;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Injector;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.S;
import osgl.version.Version;

public class BeetlView
extends View {
    public static final Version VERSION = Version.get();
    public static final String ID = "beetl";
    transient GroupTemplate beetl;
    Lang.Visitor<org.beetl.core.Template> templateModifier = new Lang.Visitor<org.beetl.core.Template>(){

        public void visit(org.beetl.core.Template template) throws Lang.Break {
        }
    };
    boolean directByteOutput;
    private String suffix;
    private static final StringTemplateResourceLoader STRING_TEMPLATE_RESOURCE_LOADER = new StringTemplateResourceLoader();

    public GroupTemplate getBeetl() {
        return this.beetl;
    }

    public String name() {
        return ID;
    }

    protected Template loadTemplate(String resourcePath) {
        if (!this.beetl.getResourceLoader().exist(resourcePath)) {
            if (resourcePath.endsWith(this.suffix)) {
                return null;
            }
            return this.loadTemplate(S.concat((String)resourcePath, (String)this.suffix));
        }
        return new BeetlTemplate(resourcePath, this);
    }

    protected Template loadInlineTemplate(String content) {
        return new BeetlTemplate(content, this, true);
    }

    protected void init(final App app) {
        try {
            Properties p;
            C.Map map = C.Map((Object[])new Object[]{"value", "/beetl.properties"});
            ConfigResourceLoader confLoader = new ConfigResourceLoader(true);
            confLoader.init((Map)map, BeanSpec.of(InputStream.class, (Injector)app.injector()));
            InputStream is = (InputStream)confLoader.get();
            Properties properties = p = null == is ? null : new Properties();
            if (null != p) {
                p.load(is);
            } else {
                this.info("beetl.properties not found, will use default configuration to init beetl template engine", new Object[0]);
            }
            Configuration conf = null == is ? Configuration.defaultConfiguration() : new Configuration(p);
            conf.setErrorHandlerClass("org.beetl.core.ReThrowConsoleErrorHandler");
            conf.setNativeSecurity("act.view.beetl.BeetlView$ACTDefaultNativeSecurityManager");
            AppClassLoader cl = app.classLoader();
            ClasspathResourceLoader loader = new ClasspathResourceLoader((ClassLoader)cl, this.templateHome());
            this.beetl = new GroupTemplate((ResourceLoader)loader, conf, (ClassLoader)app.classLoader());
            String strWebAppExt = this.beetl.getConf().getWebAppExt();
            this.initTemplateModifier(strWebAppExt);
            this.directByteOutput = conf.isDirectByteOutput();
            this.suffix = (String)app.config().get("view.beetl.suffix");
            this.suffix = null == this.suffix ? ".beetl" : (this.suffix.startsWith(".") ? this.suffix : S.concat((String)".", (String)this.suffix));
            app.jobManager().on(SysEventId.DEPENDENCY_INJECTOR_LOADED, new Runnable(){

                @Override
                public void run() {
                    app.injector().registerProvider(GroupTemplate.class, (Provider)new Provider<GroupTemplate>(){

                        public GroupTemplate get() {
                            return BeetlView.this.beetl;
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    private WebRenderExt getWebRenderExt(String clsName) {
        try {
            return (WebRenderExt)Act.app().getInstance(clsName);
        }
        catch (Exception ex) {
            throw new ConfigurationException((Throwable)ex, "Error loading WebRenderExt: %s", new Object[]{ex.getMessage()});
        }
    }

    private void initTemplateModifier(String webAppExt) {
        if (S.notBlank((String)webAppExt)) {
            final WebRenderExt ext = this.getWebRenderExt(webAppExt);
            this.templateModifier = new Lang.Visitor<org.beetl.core.Template>(){

                public void visit(org.beetl.core.Template template) throws Lang.Break {
                    ext.modify(template, BeetlView.this.beetl, null, null);
                }
            };
        }
    }

    @SubClassFinder
    public void autoRegisterFunction(Class<Function> functionClass) {
        Named named = functionClass.getAnnotation(Named.class);
        String name = null != named ? named.value() : Keyword.of((CharSequence)functionClass.getName()).javaVariable();
        this.beetl.registerFunction(name, (Function)Act.getInstance(functionClass));
    }

    public static class ACTDefaultNativeSecurityManager
    extends DefaultNativeSecurityManager {
        public boolean permit(String resourceId, Class c, Object target, String method) {
            if (c.isArray()) {
                return true;
            }
            String className = c.getName();
            String name = c.getSimpleName();
            return !className.startsWith("java.lang") || !name.equals("Runtime") && !name.equals("Process") && !name.equals("ProcessBuilder") && !name.equals("System");
        }
    }
}

