/*
 * Decompiled with CFR 0.152.
 */
package act.db.beetlsql;

import act.app.App;
import act.app.DbServiceManager;
import act.app.event.SysEventId;
import act.db.DbService;
import act.db.EntityClassRepository;
import act.db.beetlsql.BeetlSqlService;
import act.util.AnnotatedClassFinder;
import act.util.SubClassFinder;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.Entity;
import org.beetl.sql.core.annotatoin.Table;
import org.beetl.sql.core.mapper.BaseMapper;
import org.osgl.$;
import org.osgl.exception.UnexpectedException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.Generics;

@Singleton
public class BeetlClassFinder {
    private static final Logger LOGGER = LogManager.get(BeetlClassFinder.class);
    private final EntityClassRepository repo;
    private final App app;

    @Inject
    public BeetlClassFinder(EntityClassRepository repo, App app) {
        this.repo = (EntityClassRepository)$.requireNotNull((Object)repo);
        this.app = (App)$.requireNotNull((Object)app);
    }

    @AnnotatedClassFinder(value=Table.class)
    public void foundEntity(Class<?> modelClass) {
        this.repo.registerModelClass(modelClass);
    }

    @AnnotatedClassFinder(value=Entity.class)
    public void foundEntity2(Class<?> modelClass) {
        this.repo.registerModelClass(modelClass);
    }

    @SubClassFinder(noAbstract=false, callOn=SysEventId.PRE_START)
    public void foundMapper(Class<? extends BaseMapper> mapperClass) {
        if (mapperClass.getName().startsWith("org.beetl.sql.test.")) {
            return;
        }
        DbServiceManager dbServiceManager = this.app.dbServiceManager();
        try {
            Class<?> modelClass = BeetlClassFinder.modelClass(mapperClass);
            DbService dbService = dbServiceManager.dbService(DbServiceManager.dbId(modelClass));
            if (!(dbService instanceof BeetlSqlService)) {
                throw new UnexpectedException("mapper class cannot be landed to a BeetlSqlService");
            }
            ((BeetlSqlService)dbService).prepareMapperClass(mapperClass, modelClass);
        }
        catch (RuntimeException e) {
            LOGGER.warn((Throwable)e, "Error registering mapping class: %s", new Object[]{mapperClass});
        }
    }

    static Class<?> modelClass(Class<? extends BaseMapper> mapperClass) {
        List paramTypes = Generics.typeParamImplementations(mapperClass, BaseMapper.class);
        if (paramTypes.size() != 1) {
            throw new UnexpectedException("Cannot determine parameter type of %s", new Object[]{mapperClass});
        }
        Type type = (Type)paramTypes.get(0);
        if (!(type instanceof Class)) {
            throw new UnexpectedException("Cannot determine parameter type of %s", new Object[]{mapperClass});
        }
        return (Class)$.cast((Object)type);
    }
}

