/*
 * Decompiled with CFR 0.152.
 */
package act.db.beetlsql;

import act.Act;
import act.app.DbServiceManager;
import act.db.DB;
import act.db.Dao;
import act.db.DaoBase;
import act.db.DbService;
import act.db.beetlsql.BeetlSqlQuery;
import act.db.beetlsql.BeetlSqlService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.kit.BeanKit;
import org.osgl.util.E;

public class BeetlSqlDao<ID_TYPE, MODEL_TYPE>
extends DaoBase<ID_TYPE, MODEL_TYPE, BeetlSqlQuery<MODEL_TYPE>> {
    SQLManager sqlManager;
    String idAttr;

    public BeetlSqlDao() {
        DB db = this.modelType().getAnnotation(DB.class);
        String svcId = null == db ? "default" : db.value();
        DbServiceManager dbm = Act.app().dbServiceManager();
        DbService dbService = dbm.dbService(svcId);
        E.invalidConfigurationIf((null == dbService ? 1 : 0) != 0, (String)"cannot find db service by id: %s", (Object[])new Object[]{svcId});
        E.unexpectedIfNot((boolean)(dbService instanceof BeetlSqlService), (String)("expected BeetlSqlService, found: " + dbService.getClass().getSimpleName()), (Object[])new Object[0]);
        this.setBeetlSqlService((BeetlSqlService)dbService);
    }

    public BeetlSqlDao(SQLManager sqlManager, String idAttr, Class<MODEL_TYPE> modelType, Class<ID_TYPE> idType) {
        super(idType, modelType);
        this.idAttr = idAttr;
        this.sqlManager = sqlManager;
    }

    public MODEL_TYPE findById(ID_TYPE id) {
        return (MODEL_TYPE)this.sqlManager.single(this.modelType(), id);
    }

    public MODEL_TYPE findLatest() {
        throw new UnsupportedOperationException();
    }

    public MODEL_TYPE findLastModified() {
        throw new UnsupportedOperationException();
    }

    public Iterable<MODEL_TYPE> findByIdList(Collection<ID_TYPE> idList) {
        ArrayList<MODEL_TYPE> list = new ArrayList<MODEL_TYPE>(idList.size());
        for (ID_TYPE id : idList) {
            list.add(this.findById(id));
        }
        return list;
    }

    public MODEL_TYPE reload(MODEL_TYPE entity) {
        return (MODEL_TYPE)this.sqlManager.unique(this.modelType(), this.getId(entity));
    }

    public ID_TYPE getId(MODEL_TYPE entity) {
        Object value = BeanKit.getBeanProperty(entity, (String)this.idAttr);
        return (ID_TYPE)value;
    }

    public MODEL_TYPE save(MODEL_TYPE entity) {
        this.sqlManager.upsert(entity);
        return entity;
    }

    public void save(MODEL_TYPE entity, String fields, Object ... values) {
        MODEL_TYPE dbEntity = this.reload(entity);
        StringTokenizer st = new StringTokenizer(fields, ":,; ");
        int index = 0;
        while (st.hasMoreTokens()) {
            BeanKit.setBeanProperty(dbEntity, (Object)values[index++], (String)st.nextToken());
        }
        this.sqlManager.updateById(dbEntity);
    }

    public List<MODEL_TYPE> save(Iterable<MODEL_TYPE> entities) {
        ArrayList<MODEL_TYPE> list = new ArrayList<MODEL_TYPE>();
        for (MODEL_TYPE obj : entities) {
            this.sqlManager.insert(this.modelType(), obj, true);
            list.add(obj);
        }
        return list;
    }

    public void delete(MODEL_TYPE entity) {
        this.sqlManager.deleteById(this.modelType(), this.getId(entity));
    }

    public void delete(BeetlSqlQuery<MODEL_TYPE> query) {
        query.query.delete();
    }

    public void deleteById(ID_TYPE id) {
        this.sqlManager.deleteById(this.modelType(), id);
    }

    public void deleteBy(String fields, Object ... values) throws IllegalArgumentException {
        Dao.Query query = this.createQuery(fields, values);
        for (Object entity : query.fetch()) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        String tableName = this.sqlManager.getNc().getTableName(this.modelType());
        String sql = "delete from " + tableName;
        this.sqlManager.executeUpdate(new SQLReady(sql));
    }

    public void drop() {
        throw new UnsupportedOperationException("BeetlSQL \u4e0d\u652f\u6301DDL \u5220\u9664\u8868");
    }

    public BeetlSqlQuery<MODEL_TYPE> q() {
        return this.createQuery();
    }

    public BeetlSqlQuery<MODEL_TYPE> createQuery() {
        return new BeetlSqlQuery(this, this.modelType());
    }

    public BeetlSqlQuery<MODEL_TYPE> q(String fields, Object ... values) {
        return this.createQuery(fields, values);
    }

    public BeetlSqlQuery<MODEL_TYPE> createQuery(String fields, Object ... values) {
        return new BeetlSqlQuery(this, this.modelType(), fields, values);
    }

    public Object processLikeValue(String s) {
        return s.contains("%") ? s : "%" + s + "%";
    }

    private void setBeetlSqlService(BeetlSqlService beetl) {
        Class modelType = this.modelType();
        this.idAttr = beetl.idColumn(modelType);
        this.sqlManager = beetl.beetlSql();
    }
}

