/*
 * Decompiled with CFR 0.152.
 */
package act.db.beetlsql;

import act.app.App;
import act.app.event.AppPreStart;
import act.app.event.SysEventId;
import act.app.event.SysEventListener;
import act.db.DbPlugin;
import act.db.DbService;
import act.db.beetlsql.BeetlSqlService;
import act.db.beetlsql.inject.BeetlSqlProviders;
import act.db.sql.tx.TxError;
import act.db.sql.tx.TxStart;
import act.db.sql.tx.TxStop;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.event.SysEventListenerBase;
import java.util.EventObject;
import java.util.Map;
import org.beetl.sql.core.DSTransactionManager;

public class BeetlSqlPlugin
extends DbPlugin {
    protected void applyTo(App app) {
        super.applyTo(app);
        app.eventBus().bind(TxStart.class, (ActEventListener)new ActEventListenerBase<TxStart>(){

            public void on(TxStart eventObject) {
                DSTransactionManager.start();
            }
        }).bind(TxStop.class, (ActEventListener)new ActEventListenerBase(){

            public void on(EventObject eventObject) throws Exception {
                DSTransactionManager.commit();
                DSTransactionManager.clear();
            }
        }).bind(TxError.class, (ActEventListener)new ActEventListenerBase<TxError>(){

            public void on(TxError eventObject) throws Exception {
                DSTransactionManager.rollback();
                DSTransactionManager.clear();
            }
        }).bind(SysEventId.PRE_START, (SysEventListener)new SysEventListenerBase<AppPreStart>(){

            public void on(AppPreStart event) {
                BeetlSqlProviders.classInit((App)event.source());
            }
        });
    }

    public DbService initDbService(String id, App app, Map<String, String> conf) {
        return new BeetlSqlService(id, app, conf);
    }
}

