/*
 * Decompiled with CFR 0.152.
 */
package act.db.beetlsql;

import act.Act;
import act.app.App;
import act.db.Dao;
import act.db.beetlsql.BeetlSqlDao;
import act.db.sql.DataSourceConfig;
import act.db.sql.DataSourceProvider;
import act.db.sql.SqlDbService;
import act.db.sql.util.NamingConvention;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.DSTransactionManager;
import org.beetl.sql.core.DefaultNameConversion;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.UnderlinedNameConversion;
import org.beetl.sql.core.annotatoin.Table;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.DB2SqlStyle;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.H2Style;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.core.db.OracleStyle;
import org.beetl.sql.core.db.PostgresStyle;
import org.beetl.sql.core.db.SQLiteStyle;
import org.beetl.sql.core.db.SqlServerStyle;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.mapper.BaseMapper;
import org.beetl.sql.core.mapper.DefaultMapperBuilder;
import org.beetl.sql.core.mapper.MapperBuilder;
import org.beetl.sql.ext.DebugInterceptor;
import org.osgl.inject.Genie;
import org.osgl.util.E;
import org.osgl.util.S;

public class BeetlSqlService
extends SqlDbService {
    public static final String DEF_LOADER_PATH = "/sql";
    private SQLManager beetlSql;
    private MapperBuilder mapperBuilder;
    private ConcurrentMap<Class, BaseMapper> mapperMap = new ConcurrentHashMap<Class, BaseMapper>();
    private ConnectionSource connectionSource;

    public BeetlSqlService(String dbId, App app, Map<String, String> config) {
        super(dbId, app, config);
    }

    public SQLManager beetlSql() {
        return this.beetlSql;
    }

    protected DataSourceProvider builtInDataSourceProvider() {
        throw E.unsupport();
    }

    protected void doStartTx(Object delegate, boolean readOnly) {
        DSTransactionManager.start();
    }

    protected void doRollbackTx(Object delegate, Throwable cause) {
        try {
            DSTransactionManager.rollback();
        }
        catch (SQLException e) {
            this.logger.warn((Throwable)e, "Error rolling back transaction");
        }
    }

    protected void doEndTxIfActive(Object delegate) {
        if (!DSTransactionManager.inTrans()) {
            return;
        }
        try {
            DSTransactionManager.commit();
        }
        catch (SQLException e) {
            this.logger.warn((Throwable)e, "Error commit transaction");
        }
    }

    protected void dataSourceProvided(DataSource dataSource, DataSourceConfig dataSourceConfig, boolean readonly) {
        this.connectionSource = ConnectionSourceHelper.getSingle((DataSource)dataSource);
        DBStyle style = this.configureDbStyle(dataSourceConfig);
        SQLLoader loader = this.configureLoader();
        NameConversion nm = this.configureNamingConvention();
        Interceptor[] ins = this.configureInterceptor();
        this.beetlSql = new SQLManager(style, loader, this.connectionSource, nm, ins);
        this.beetlSql.setEntityLoader((ClassLoader)this.app().classLoader());
        this.mapperBuilder = new DefaultMapperBuilder(this.beetlSql);
    }

    protected boolean supportDdl() {
        return false;
    }

    public <DAO extends Dao> DAO defaultDao(Class<?> aClass) {
        String idAttr;
        Class<?> idType;
        block1: {
            String tableName = this.beetlSql.getNc().getTableName(aClass);
            TableDesc tableDesc = this.beetlSql.getMetaDataManager().getTable(tableName);
            ClassDesc classDesc = tableDesc.getClassDesc(aClass, this.beetlSql.getNc());
            Map idMethod = classDesc.getIdMethods();
            if (idMethod.size() > 1) {
                throw new IllegalStateException("BeetlSQL \u76ee\u524d\u4e0d\u652f\u6301\u5728ACT\u4e2d\u4f7f\u7528\u590d\u5408\u4e3b\u5065");
            }
            idType = null;
            idAttr = null;
            Iterator iterator = idMethod.entrySet().iterator();
            if (!iterator.hasNext()) break block1;
            Map.Entry entry = iterator.next();
            idAttr = (String)entry.getKey();
            Method method = (Method)entry.getValue();
            idType = method.getReturnType();
        }
        return (DAO)((Object)this.newDao(idAttr, idType, aClass));
    }

    protected <ID_TYPE, MODEL_TYPE> BeetlSqlDao<ID_TYPE, MODEL_TYPE> newDao(String idAttr, Class<ID_TYPE> idType, Class<MODEL_TYPE> modelType) {
        return new BeetlSqlDao<ID_TYPE, MODEL_TYPE>(this.beetlSql, idAttr, modelType, idType);
    }

    public <DAO extends Dao> DAO newDaoInstance(Class<DAO> aClass) {
        try {
            return (DAO)((Dao)aClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Class<? extends Annotation> entityAnnotationType() {
        return Table.class;
    }

    protected void releaseResources() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("beetsql shutdown: %s", new Object[]{this.id()});
        }
        super.releaseResources();
    }

    BaseMapper mapper(Class modelClass) {
        return (BaseMapper)this.mapperMap.get(modelClass);
    }

    public <MAPPER extends BaseMapper> void prepareMapperClass(Class<MAPPER> mapperClass, Class<?> modelClass) {
        final BaseMapper mapper = (BaseMapper)this.mapperBuilder.getMapper(mapperClass);
        this.mapperMap.put(mapperClass, mapper);
        this.mapperMap.put(modelClass, mapper);
        Genie genie = (Genie)Act.getInstance(Genie.class);
        genie.registerProvider(mapperClass, new Provider<MAPPER>(){

            public MAPPER get() {
                return mapper;
            }
        });
    }

    private NameConversion configureNamingConvention() {
        String s = (String)this.config.rawConf.get("beetlsql.nc");
        if (null != s) {
            return (NameConversion)Act.getInstance((String)s);
        }
        if (NamingConvention.Default.UNDERSCORE == this.config.tableNamingConvention) {
            return new UnderlinedNameConversion();
        }
        return new DefaultNameConversion();
    }

    private SQLLoader configureLoader() {
        String loaderPath = (String)this.config.rawConf.get("loader.path");
        if (null == loaderPath) {
            loaderPath = DEF_LOADER_PATH;
        }
        return new ClasspathLoader(loaderPath);
    }

    private Interceptor[] configureInterceptor() {
        Interceptor[] interceptorArray;
        boolean isDebug = Act.isDev();
        if (!isDebug) {
            String debug = (String)this.config.rawConf.get("interceptor.debug");
            if (null == debug) {
                return new Interceptor[0];
            }
            isDebug = Boolean.parseBoolean(debug);
        }
        if (isDebug) {
            Interceptor[] interceptorArray2 = new Interceptor[1];
            interceptorArray = interceptorArray2;
            interceptorArray2[0] = new DebugInterceptor();
        } else {
            interceptorArray = new Interceptor[]{};
        }
        return interceptorArray;
    }

    private DBStyle configureDbStyle(DataSourceConfig dsConfig) {
        Map conf = this.config.rawConf;
        String style = (String)conf.get("platform");
        if (null == style) {
            style = (String)conf.get("style");
        }
        if (null == style) {
            style = dsConfig.url;
        }
        if (S.notBlank((String)style)) {
            if ((style = style.trim().toLowerCase()).contains("oracle")) {
                return new OracleStyle();
            }
            if (style.contains("mysql") || style.contains("maria")) {
                return new MySqlStyle();
            }
            if (style.contains("postgres") || style.contains("pgsql")) {
                return new PostgresStyle();
            }
            if (style.contains("h2")) {
                return new H2Style();
            }
            if (style.contains("sqlserver")) {
                return new SqlServerStyle();
            }
            if (style.contains("db2")) {
                return new DB2SqlStyle();
            }
            if (style.contains("sqlite")) {
                return new SQLiteStyle();
            }
        }
        throw new UnsupportedOperationException("Unknown database style: " + style);
    }
}

