/*
 * Decompiled with CFR 0.152.
 */
package act.db.beetlsql;

import java.sql.SQLException;
import javax.inject.Singleton;
import org.beetl.sql.core.DSTransactionManager;
import org.osgl.exception.UnexpectedException;
import org.osgl.mvc.annotation.After;
import org.osgl.mvc.annotation.Before;
import org.osgl.mvc.annotation.Catch;
import org.osgl.mvc.annotation.Finally;

@Singleton
public class BeetlSqlTransactional {
    public static final int INTERCEPTOR_PRIORITY = -99;

    @Before(priority=-99)
    public void start() {
        DSTransactionManager.start();
    }

    @After(priority=99)
    public void commit() {
        try {
            DSTransactionManager.commit();
        }
        catch (SQLException e) {
            this.rollback();
        }
    }

    @Catch(value={Exception.class}, priority=-99)
    public void rollback() {
        try {
            DSTransactionManager.rollback();
        }
        catch (SQLException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    @Finally
    public void clear() {
        DSTransactionManager.clear();
    }
}

