/*
 * Decompiled with CFR 0.152.
 */
package act.db.ebean;

import act.Act;
import act.app.DbServiceManager;
import act.db.DB;
import act.db.Dao;
import act.db.DaoBase;
import act.db.DbService;
import act.db.Model;
import act.db.ebean.EbeanQuery;
import act.db.ebean.EbeanService;
import act.inject.param.NoBind;
import act.util.General;
import io.ebean.EbeanServer;
import io.ebean.ExpressionList;
import io.ebean.QueryIterator;
import io.ebean.SqlUpdate;
import io.ebean.Transaction;
import io.ebeaninternal.api.SpiEbeanServer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Id;
import javax.sql.DataSource;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

@General
@NoBind
public class EbeanDao<ID_TYPE, MODEL_TYPE>
extends DaoBase<ID_TYPE, MODEL_TYPE, EbeanQuery<MODEL_TYPE>> {
    private static final Logger logger = L.get(EbeanDao.class);
    private volatile EbeanServer ebean;
    private volatile DataSource ds;
    private String tableName;
    private Field idField = null;
    private List<QueryIterator> queryIterators = C.newList();
    public static final String ID = "_id";

    EbeanDao(EbeanService service) {
        this.init(this.modelType());
        this.ebean(service.ebean());
    }

    EbeanDao(Class<ID_TYPE> idType, Class<MODEL_TYPE> modelType, EbeanService service) {
        super(idType, modelType);
        this.init(modelType);
        this.setEbean(service.ebean());
        this.ds = service.dataSource();
    }

    public EbeanDao(Class<ID_TYPE> id_type, Class<MODEL_TYPE> modelType) {
        super(id_type, modelType);
        this.init(modelType);
    }

    public EbeanDao() {
        this.init(this.modelType());
    }

    public void ebean(EbeanServer ebean) {
        this.setEbean((EbeanServer)$.notNull((Object)ebean));
    }

    public void modelType(Class<?> type) {
        this.modelType = (Type)$.cast(type);
    }

    protected void releaseResources() {
        if (null != this.queryIterators) {
            for (QueryIterator i : this.queryIterators) {
                try {
                    i.close();
                }
                catch (Exception e) {
                    logger.warn((Throwable)e, "error closing query iterators");
                }
            }
            this.queryIterators.clear();
            this.queryIterators = null;
        }
    }

    private void init(Class<MODEL_TYPE> modelType) {
        for (Field f : modelType.getDeclaredFields()) {
            Id idAnno = f.getAnnotation(Id.class);
            if (null == idAnno) continue;
            this.idField = f;
            f.setAccessible(true);
            break;
        }
    }

    private void setEbean(EbeanServer ebean) {
        this.ebean = ebean;
        this.tableName = ((SpiEbeanServer)ebean).getBeanDescriptor(this.modelType()).getBaseTable();
    }

    private EbeanService getService(String dbId, DbServiceManager mgr) {
        DbService svc = mgr.dbService(dbId);
        E.invalidConfigurationIf((null == svc ? 1 : 0) != 0, (String)"Cannot find db service by id: %s", (Object[])new Object[]{dbId});
        E.invalidConfigurationIf((!(svc instanceof EbeanService) ? 1 : 0) != 0, (String)"The db service[%s|%s] is not ebean service", (Object[])new Object[]{dbId, svc.getClass()});
        return (EbeanService)((Object)$.cast((Object)svc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EbeanServer ebean() {
        if (null != this.ebean) {
            return this.ebean;
        }
        EbeanDao ebeanDao = this;
        synchronized (ebeanDao) {
            if (null == this.ebean) {
                DB db = this.modelType().getAnnotation(DB.class);
                String dbId = null == db ? "default" : db.value();
                EbeanService dbService = this.getService(dbId, Act.app().dbServiceManager());
                E.NPE((Object)((Object)dbService));
                this.setEbean(dbService.ebean());
            }
        }
        return this.ebean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource ds() {
        if (null != this.ds) {
            return this.ds;
        }
        EbeanDao ebeanDao = this;
        synchronized (ebeanDao) {
            if (null == this.ds) {
                DB db = this.modelType().getAnnotation(DB.class);
                String dbId = null == db ? "default" : db.value();
                EbeanService dbService = this.getService(dbId, Act.app().dbServiceManager());
                E.NPE((Object)((Object)dbService));
                this.ds = dbService.dataSource();
            }
        }
        return this.ds;
    }

    void registerQueryIterator(QueryIterator i) {
        this.queryIterators.add(i);
    }

    public MODEL_TYPE findById(ID_TYPE id) {
        return (MODEL_TYPE)this.ebean().find(this.modelType(), id);
    }

    public MODEL_TYPE findLatest() {
        throw E.unsupport();
    }

    public MODEL_TYPE findLastModified() {
        throw E.unsupport();
    }

    public Iterable<MODEL_TYPE> findBy(String fields, Object ... values) throws IllegalArgumentException {
        Dao.Query q = this.q(fields, values);
        return q.fetch();
    }

    public Iterable<MODEL_TYPE> findByIdList(Collection<ID_TYPE> idList) {
        Dao.Query q = this.q();
        q.where().idIn((Collection)C.list(idList));
        return q.fetch();
    }

    public MODEL_TYPE findOneBy(String fields, Object ... values) throws IllegalArgumentException {
        Dao.Query q = this.q(fields, values);
        return q.first();
    }

    public Iterable<MODEL_TYPE> findAll() {
        return this.q().fetch();
    }

    public List<MODEL_TYPE> findAllAsList() {
        return this.q().findList();
    }

    public MODEL_TYPE reload(MODEL_TYPE entity) {
        this.ebean().refresh(entity);
        return entity;
    }

    public ID_TYPE getId(MODEL_TYPE entity) {
        if (entity instanceof Model) {
            return (ID_TYPE)((Model)entity)._id();
        }
        if (null != this.idField) {
            try {
                return (ID_TYPE)this.idField.get(entity);
            }
            catch (IllegalAccessException e) {
                throw E.unexpected((Throwable)e);
            }
        }
        return null;
    }

    public long count() {
        return this.q().findCount();
    }

    public long countBy(String fields, Object ... values) throws IllegalArgumentException {
        Dao.Query q = this.q(fields, values);
        return q.count();
    }

    public MODEL_TYPE save(MODEL_TYPE entity) {
        this.ebean().save(entity);
        return entity;
    }

    public MODEL_TYPE save(Transaction tx, MODEL_TYPE entity) {
        this.ebean().save(entity, tx);
        return entity;
    }

    public List<MODEL_TYPE> save(Iterable<MODEL_TYPE> iterable) {
        C.List list = C.list(iterable);
        if (list.isEmpty()) {
            return list;
        }
        this.ebean().saveAll((Collection)list);
        return list;
    }

    public List<MODEL_TYPE> save(Transaction tx, Iterable<MODEL_TYPE> iterable) {
        C.List list = C.list(iterable);
        this.ebean().saveAll((Collection)list, tx);
        return list;
    }

    public void save(MODEL_TYPE entity, String fields, Object ... values) throws IllegalArgumentException {
        this.ebean().update(entity);
    }

    public void save(Transaction tx, MODEL_TYPE entity, String fields, Object ... values) throws IllegalArgumentException {
        this.ebean().update(entity, tx);
    }

    public void delete(MODEL_TYPE entity) {
        this.ebean().delete(entity);
    }

    public void delete(Transaction tx, MODEL_TYPE entity) {
        this.ebean().delete(entity, tx);
    }

    public void delete(EbeanQuery<MODEL_TYPE> query) {
        this.ebean().delete(query.rawQuery(), null);
    }

    public void delete(Transaction tx, EbeanQuery<MODEL_TYPE> query) {
        this.ebean().delete(query.rawQuery(), tx);
    }

    public void deleteById(ID_TYPE id) {
        this.ebean().delete(this.modelType(), id);
    }

    public void deleteById(Transaction tx, ID_TYPE id) {
        this.ebean().delete(this.modelType(), id, tx);
    }

    public void deleteBy(String fields, Object ... values) throws IllegalArgumentException {
        this.delete((EbeanQuery<MODEL_TYPE>)this.q(fields, values));
    }

    public void deleteBy(Transaction tx, String fields, Object ... values) throws IllegalArgumentException {
        this.delete(tx, (EbeanQuery<MODEL_TYPE>)this.q(fields, values));
    }

    public void deleteAll() {
        this.delete((EbeanQuery<MODEL_TYPE>)this.q());
    }

    public void deleteAll(Transaction tx) {
        this.delete(tx, (EbeanQuery<MODEL_TYPE>)this.q());
    }

    public void drop() {
        String sql = "DELETE from " + this.tableName;
        SqlUpdate sqlUpdate = this.ebean().createSqlUpdate(sql);
        this.ebean().execute(sqlUpdate);
    }

    public EbeanQuery<MODEL_TYPE> q() {
        return new EbeanQuery(this, this.modelType());
    }

    public EbeanQuery<MODEL_TYPE> createQuery() {
        return this.q();
    }

    boolean ebeanServerProvided() {
        return null != this.ebean;
    }

    private void buildWhere(ExpressionList<MODEL_TYPE> where, String key, Object val) {
        String[] sa = key.split("\\s+");
        switch (sa.length) {
            case 1: {
                where.eq(sa[0], val);
                break;
            }
            case 2: {
                R1.valueOf(sa[1]).applyTo(where, sa[0], val);
                break;
            }
            case 3: {
                R2.valueOf(sa[2]).applyTo(where, sa[0], sa[1], val);
                break;
            }
            default: {
                throw E.unexpected((String)"Unknown where expression: %s", (Object[])new Object[]{key});
            }
        }
    }

    public EbeanQuery<MODEL_TYPE> q(String keys, Object ... values) {
        int len = values.length;
        E.illegalArgumentIf((len == 0 ? 1 : 0) != 0, (String)"no values supplied");
        String[] sa = keys.split("[,;:]+");
        E.illegalArgumentIf((sa.length != len ? 1 : 0) != 0, (String)"The number of values does not match the number of fields");
        Dao.Query q = this.q();
        ExpressionList el = q.where();
        for (int i = 0; i < len; ++i) {
            this.buildWhere(el, sa[i], values[i]);
        }
        return q;
    }

    public EbeanQuery<MODEL_TYPE> createQuery(String s, Object ... objects) {
        return this.q(s, objects);
    }

    private static enum R1 {
        eq{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                if (EbeanDao.ID.equals(field)) {
                    where.idEq(val);
                    return;
                }
                if (null == val) {
                    where.isNull(field);
                } else {
                    where.eq(field, val);
                }
            }
        }
        ,
        ne{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.ne(field, val);
            }
        }
        ,
        ieq{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.ieq(field, val.toString());
            }
        }
        ,
        between{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                if (val instanceof Lang.T2) {
                    Lang.T2 t2 = (Lang.T2)$.cast((Object)val);
                    where.between(field, t2._1, t2._2);
                } else if (val.getClass().isArray()) {
                    int len = Array.getLength(val);
                    if (len != 2) {
                        throw E.unexpected((String)"<between> value array length is not correct, expected: 2; found: %s", (Object[])new Object[]{len});
                    }
                    where.between(field, Array.get(val, 0), Array.get(val, 1));
                } else if (val instanceof Collection) {
                    int len = ((Collection)val).size();
                    if (len != 2) {
                        throw E.unexpected((String)"<between> value collection size is not correct, expected: 2; found: %s", (Object[])new Object[]{len});
                    }
                    Iterator itr = ((Collection)val).iterator();
                    where.between(field, itr.next(), itr.next());
                } else {
                    throw E.unexpected((String)"<between> value type not recognized: %s", (Object[])new Object[]{val.getClass()});
                }
            }
        }
        ,
        gt{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.gt(field, val);
            }
        }
        ,
        ge{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.ge(field, val);
            }
        }
        ,
        lt{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.lt(field, val);
            }
        }
        ,
        le{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.le(field, val);
            }
        }
        ,
        isNull{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.isNull(field);
            }
        }
        ,
        isNotNull{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.isNotNull(field);
            }
        }
        ,
        like{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                String s = S.string((Object)val);
                if (!s.contains("%")) {
                    s = S.builder((String)"%").append(s).append("%").toString();
                }
                where.like(field, s);
            }
        }
        ,
        ilike{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                String s = S.string((Object)val);
                if (!s.contains("%")) {
                    s = S.builder((String)"%").append(s).append("%").toString();
                }
                where.ilike(field, s);
            }
        }
        ,
        startsWith{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.startsWith(field, val.toString());
            }
        }
        ,
        istartsWith{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.istartsWith(field, val.toString());
            }
        }
        ,
        endsWith{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.endsWith(field, val.toString());
            }
        }
        ,
        contains{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.contains(field, val.toString());
            }
        }
        ,
        icontains{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                where.icontains(field, val.toString());
            }
        }
        ,
        in{

            @Override
            void applyTo(ExpressionList<?> where, String field, Object val) {
                E.NPE((Object)field, (Object)val);
                if (val instanceof Dao.Query) {
                    where.in(field, new Object[]{(Dao.Query)val});
                } else if (val instanceof Collection) {
                    if (EbeanDao.ID.equals(field)) {
                        where.idIn((Collection)C.list((Collection)((Collection)val)));
                    } else {
                        where.in(field, (Collection)val);
                    }
                } else if (val.getClass().isArray()) {
                    int len = Array.getLength(val);
                    if (len == 0) {
                        if (EbeanDao.ID.equals(field)) {
                            where.idIn((Collection)C.list());
                        } else {
                            where.in(field, new Object[0]);
                        }
                    } else {
                        Object[] array = new Object[len];
                        for (int i = 0; i < len; ++i) {
                            array[i] = Array.get(val, i);
                        }
                        if (EbeanDao.ID.equals(field)) {
                            where.idIn((Collection)C.listOf((Object[])array));
                        } else {
                            where.in(field, array);
                        }
                    }
                } else {
                    throw E.unexpected((String)"Unknown <in> value type: %s", (Object[])new Object[]{val.getClass()});
                }
            }
        };


        abstract void applyTo(ExpressionList<?> var1, String var2, Object var3);
    }

    private static enum R2 {
        betweenProperties{

            @Override
            void applyTo(ExpressionList<?> where, String field1, String field2, Object val) {
                where.betweenProperties(field1, field2, val);
            }
        }
        ,
        bp{

            @Override
            void applyTo(ExpressionList<?> where, String field1, String field2, Object val) {
                where.betweenProperties(field1, field2, val);
            }
        };


        abstract void applyTo(ExpressionList<?> var1, String var2, String var3, Object var4);
    }
}

