/*
 * Decompiled with CFR 0.152.
 */
package act.db.ebean;

import act.app.App;
import act.db.DbPlugin;
import act.db.DbService;
import act.db.ebean.EbeanService;
import act.db.sql.tx.TxError;
import act.db.sql.tx.TxInfo;
import act.db.sql.tx.TxStart;
import act.db.sql.tx.TxStop;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.inject.param.ParamValueLoaderService;
import io.ebean.TxScope;
import io.ebeaninternal.api.HelpScopeTrans;
import java.util.EventObject;
import java.util.Map;
import osgl.version.Version;

public class EbeanPlugin
extends DbPlugin {
    public static final Version VERSION = Version.of(EbeanPlugin.class);

    protected void applyTo(App app) {
        super.applyTo(app);
        app.eventBus().bind(TxStart.class, (ActEventListener)new ActEventListenerBase<TxStart>(){

            public void on(TxStart eventObject) {
                TxInfo info = (TxInfo)eventObject.source();
                TxScope scope = new TxScope();
                scope.setReadOnly(info.readOnly());
                HelpScopeTrans.enter((TxScope)scope);
            }
        }).bind(TxStop.class, (ActEventListener)new ActEventListenerBase(){

            public void on(EventObject eventObject) throws Exception {
                HelpScopeTrans.exit(null, (int)1);
            }
        }).bind(TxError.class, (ActEventListener)new ActEventListenerBase<TxError>(){

            public void on(TxError eventObject) throws Exception {
                Throwable cause = (Throwable)eventObject.source();
                HelpScopeTrans.exit((Object)cause, (int)191);
            }
        });
    }

    public DbService initDbService(String id, App app, Map<String, String> conf) {
        ParamValueLoaderService.waiveFields((String[])new String[]{"_ebean_intercept", "_ebean_identity"});
        return new EbeanService(id, app, conf);
    }
}

