/*
 * Decompiled with CFR 0.152.
 */
package act.db.ebean2;

import act.Act;
import act.app.event.AppEventId;
import act.sys.Env;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.avaje.agentloader.AgentLoader;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.S;
import sun.tools.attach.BsdVirtualMachine;
import sun.tools.attach.LinuxVirtualMachine;
import sun.tools.attach.SolarisVirtualMachine;
import sun.tools.attach.WindowsVirtualMachine;

public class EbeanAgentLoader
extends AgentLoader {
    private static final Logger LOGGER = LogManager.get((String)EbeanAgentLoader.class.getName());
    private static final List<String> loaded = new ArrayList<String>();
    private static final AttachProvider ATTACH_PROVIDER = new AttachProvider(){

        @Override
        public String name() {
            return null;
        }

        @Override
        public String type() {
            return null;
        }

        @Override
        public VirtualMachine attachVirtualMachine(String id) {
            return null;
        }

        @Override
        public List<VirtualMachineDescriptor> listVirtualMachines() {
            return null;
        }
    };

    public static void loadAgent(String jarFilePath) {
        EbeanAgentLoader.loadAgent(jarFilePath, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAgent(String jarFilePath, String params) {
        try {
            String pid = Env.PID.get();
            VirtualMachine vm = AttachProvider.providers().isEmpty() ? EbeanAgentLoader.getVirtualMachineImplementationFromEmbeddedOnes(pid) : VirtualMachine.attach(pid);
            PrintStream ps = System.out;
            try {
                System.setOut(new PrintStream(new FileOutputStream(".ebean_agent.log")));
                vm.loadAgent(jarFilePath, params);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("javaagent loaded: " + jarFilePath);
                }
            }
            finally {
                Act.jobManager().on(AppEventId.CLASS_LOADER_INITIALIZED, () -> System.setOut(ps));
            }
            vm.detach();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadAgentFromClasspath(String agentName) {
        EbeanAgentLoader.loadAgentFromClasspath(agentName, "");
    }

    public static synchronized boolean loadAgentFromClasspath(String agentName, String params) {
        if (loaded.contains(agentName)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(S.concat((String)"agent already loaded: ", (String)agentName));
            }
            return true;
        }
        try {
            ClassLoader cl0 = AgentLoader.class.getClassLoader();
            if (!(cl0 instanceof URLClassLoader)) {
                cl0 = cl0.getParent();
            }
            if (cl0 instanceof URLClassLoader) {
                URLClassLoader cl = (URLClassLoader)cl0;
                for (URL url : cl.getURLs()) {
                    if (!EbeanAgentLoader.isMatch(url, agentName)) continue;
                    String fullName = url.toURI().getPath();
                    if (fullName.startsWith("/") && EbeanAgentLoader.isWindows()) {
                        fullName = fullName.substring(1);
                    }
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(S.concat((String)"loading agent: ", (String)fullName));
                    }
                    EbeanAgentLoader.loadAgent(fullName, params);
                    loaded.add(agentName);
                    return true;
                }
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("agent not found");
            }
            return false;
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    private static boolean isMatch(URL url, String partial) {
        String fullPath = url.getFile();
        int lastSlash = fullPath.lastIndexOf(47);
        if (lastSlash < 0) {
            return false;
        }
        String jarName = fullPath.substring(lastSlash + 1);
        return jarName.startsWith(partial);
    }

    private static final boolean isWindows() {
        return File.separatorChar == '\\';
    }

    private static VirtualMachine getVirtualMachineImplementationFromEmbeddedOnes(String pid) {
        try {
            if (EbeanAgentLoader.isWindows()) {
                return new WindowsVirtualMachine(ATTACH_PROVIDER, pid);
            }
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Linux") || osName.startsWith("LINUX")) {
                return new LinuxVirtualMachine(ATTACH_PROVIDER, pid);
            }
            if (osName.startsWith("Mac OS X")) {
                return new BsdVirtualMachine(ATTACH_PROVIDER, pid);
            }
            if (osName.startsWith("Solaris")) {
                return new SolarisVirtualMachine(ATTACH_PROVIDER, pid);
            }
        }
        catch (AttachNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnsatisfiedLinkError e) {
            throw new IllegalStateException("Native library for Attach API not available in this JRE", e);
        }
        return null;
    }
}

