/*
 * Decompiled with CFR 0.152.
 */
package act.view.excel;

import act.Act;
import act.ActResponse;
import act.app.ActionContext;
import act.view.TemplateBase;
import act.view.excel.JexlFunctionManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.jxls.common.Context;
import org.jxls.expression.JexlExpressionEvaluator;
import org.jxls.transform.Transformer;
import org.jxls.util.JxlsHelper;
import org.jxls.util.TransformerFactory;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.mvc.result.ServerError;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

class ExcelTemplate
extends TemplateBase {
    private URL resource;

    ExcelTemplate(URL url) {
        this.resource = (URL)$.notNull((Object)url);
    }

    protected void beforeRender(ActionContext context) {
        H.Format format = context.accept();
        String contentType = format.contentType();
        ActResponse response = context.resp();
        response.contentType(contentType);
        if (!response.containsHeader("content-disposition")) {
            String name = context.paramVal("filename");
            if (S.blank((String)name)) {
                name = S.afterLast((String)context.actionPath(), (String)".");
                name = S.fmt((String)"%s.%s", (Object[])new Object[]{name, format.name()});
            }
            response.contentDisposition(name, false);
        }
    }

    protected void merge(Map<String, Object> renderArgs, H.Response response) {
        Context context = new Context(renderArgs);
        InputStream is = IO.is((URL)this.resource);
        try {
            Transformer transformer = TransformerFactory.createTransformer((InputStream)is, (OutputStream)response.outputStream());
            JexlExpressionEvaluator evaluator = (JexlExpressionEvaluator)transformer.getTransformationConfig().getExpressionEvaluator();
            JexlFunctionManager funcMgr = (JexlFunctionManager)((Object)Act.getInstance(JexlFunctionManager.class));
            evaluator.getJexlEngine().setFunctions(funcMgr.functions());
            JxlsHelper.getInstance().processTemplate(context, transformer);
        }
        catch (IOException e) {
            throw new ServerError((Throwable)e, "Error processing excel template: %s", new Object[]{this.resource.getPath()});
        }
    }

    protected String render(Map<String, Object> map) {
        throw E.unsupport();
    }
}

