/*
 * Decompiled with CFR 0.152.
 */
package act.view.excel;

import act.app.App;
import act.app.event.SysEventId;
import act.app.event.SysEventListener;
import act.event.SysEventListenerBase;
import act.util.ActContext;
import act.view.Template;
import act.view.TemplatePathResolver;
import act.view.View;
import act.view.excel.ExcelTemplate;
import act.view.excel.JexlFunctionLoader;
import java.net.URL;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import org.osgl.http.H;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import osgl.version.Version;
import osgl.version.Versioned;

@Versioned
public class ExcelView
extends View {
    public static final Version VERSION = Version.of(ExcelView.class);
    public static final String ID = "excel";
    public static final Set<H.Format> SUPPORTED_FORMATS = C.setOf((Object[])new H.Format[]{H.Format.XLS, H.Format.XLSX});

    public String name() {
        return ID;
    }

    protected void init(final App app) {
        TemplatePathResolver.registerSupportedFormats(SUPPORTED_FORMATS);
        app.eventBus().bind(SysEventId.PRE_START, (SysEventListener)new SysEventListenerBase(){

            public void on(EventObject event) throws Exception {
                ((JexlFunctionLoader)app.getInstance(JexlFunctionLoader.class)).load();
            }
        });
    }

    public boolean appliedTo(ActContext context) {
        return SUPPORTED_FORMATS.contains(context.accept());
    }

    protected Template loadTemplate(String resourcePath) {
        URL url = ExcelView.class.getResource(S.fmt((String)"/%s%s", (Object[])new Object[]{ID, resourcePath}));
        return null == url ? null : new ExcelTemplate(url);
    }

    protected Template loadInlineTemplate(String content) {
        throw E.unsupport((String)"Excel view does not support inline template", (Object[])new Object[0]);
    }

    public List<String> loadContent(String template) {
        throw E.unsupport();
    }
}

