/*
 * Decompiled with CFR 0.152.
 */
package act.db.hibernate;

import act.app.App;
import act.db.DbService;
import act.db.hibernate.HibernateService;
import act.db.jpa.JPAPlugin;
import java.util.Map;
import osgl.version.Version;
import osgl.version.Versioned;

@Versioned
public class HibernatePlugin
extends JPAPlugin {
    public static final Version VERSION = Version.of(HibernatePlugin.class);

    public DbService initDbService(String id, App app, Map<String, String> conf) {
        return new HibernateService(id, app, conf);
    }

    public static String getDefaultDialect(Map<String, String> dbConfig, String driver) {
        String dialect = dbConfig.get("jpa.dialect");
        if (dialect != null) {
            return dialect;
        }
        if ("org.h2.Driver".equals(driver)) {
            return "org.hibernate.dialect.H2Dialect";
        }
        if ("org.hsqldb.jdbcDriver".equals(driver)) {
            return "org.hibernate.dialect.HSQLDialect";
        }
        if ("com.mysql.jdbc.Driver".equals(driver)) {
            return "org.hibernate.dialect.MySQLDialect";
        }
        if ("org.postgresql.Driver".equals(driver)) {
            return "org.hibernate.dialect.PostgreSQLDialect";
        }
        if ("com.ibm.db2.jdbc.app.DB2Driver".equals(driver)) {
            return "org.hibernate.dialect.DB2Dialect";
        }
        if ("com.ibm.as400.access.AS400JDBCDriver".equals(driver)) {
            return "org.hibernate.dialect.DB2400Dialect";
        }
        if ("com.ibm.as400.access.AS390JDBCDriver".equals(driver)) {
            return "org.hibernate.dialect.DB2390Dialect";
        }
        if ("oracle.jdbc.OracleDriver".equals(driver)) {
            return "org.hibernate.dialect.Oracle10gDialect";
        }
        if ("com.sybase.jdbc2.jdbc.SybDriver".equals(driver)) {
            return "org.hibernate.dialect.SybaseAnywhereDialect";
        }
        if ("com.microsoft.jdbc.sqlserver.SQLServerDriver".equals(driver)) {
            return "org.hibernate.dialect.SQLServerDialect";
        }
        if ("com.sap.dbtech.jdbc.DriverSapDB".equals(driver)) {
            return "org.hibernate.dialect.SAPDBDialect";
        }
        if ("com.informix.jdbc.IfxDriver".equals(driver)) {
            return "org.hibernate.dialect.InformixDialect";
        }
        if ("com.ingres.jdbc.IngresDriver".equals(driver)) {
            return "org.hibernate.dialect.IngresDialect";
        }
        if ("progress.sql.jdbc.JdbcProgressDriver".equals(driver)) {
            return "org.hibernate.dialect.ProgressDialect";
        }
        if ("com.mckoi.JDBCDriver".equals(driver)) {
            return "org.hibernate.dialect.MckoiDialect";
        }
        if ("InterBase.interclient.Driver".equals(driver)) {
            return "org.hibernate.dialect.InterbaseDialect";
        }
        if ("com.pointbase.jdbc.jdbcUniversalDriver".equals(driver)) {
            return "org.hibernate.dialect.PointbaseDialect";
        }
        if ("com.frontbase.jdbc.FBJDriver".equals(driver)) {
            return "org.hibernate.dialect.FrontbaseDialect";
        }
        if ("org.firebirdsql.jdbc.FBDriver".equals(driver)) {
            return "org.hibernate.dialect.FirebirdDialect";
        }
        throw new UnsupportedOperationException("I do not know which hibernate dialect to use with " + driver + " and I cannot guess it, use the property jpa.dialect in config file");
    }
}

