/*
 * Decompiled with CFR 0.152.
 */
package act.db.hibernate;

import act.Act;
import act.app.App;
import act.db.hibernate.HibernatePlugin;
import act.db.jpa.JPAService;
import act.db.sql.DataSourceConfig;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.osgl.util.C;
import org.osgl.util.E;
import org.rythmengine.utils.S;

public class HibernateService
extends JPAService {
    public HibernateService(String dbId, App app, Map<String, String> config) {
        super(dbId, app, config);
    }

    protected Properties processProperties(Properties properties, DataSourceConfig dataSourceConfig, boolean useExternalDataSource) {
        properties.put("javax.persistence.provider", "org.hibernate.ejb.HibernatePersistence");
        properties.put("hibernate.ejb.loaded.classes", C.list((Collection)this.entityClasses()));
        properties.put("hibernate.dialect", HibernatePlugin.getDefaultDialect(this.config.rawConf, this.config.dataSourceConfig.driver));
        String s = (String)this.config.rawConf.get("jpa.ddl");
        if (null == s) {
            String string = s = Act.isDev() ? "update" : "none";
        }
        if (S.ne((String)"none", (String)s)) {
            properties.setProperty("hibernate.hbm2ddl.auto", s);
        }
        return super.processProperties(properties, dataSourceConfig, useExternalDataSource);
    }

    protected Class<? extends PersistenceProvider> persistenceProviderClass() {
        return HibernatePersistenceProvider.class;
    }

    protected void dataSourceProvided(DataSource dataSource, DataSourceConfig dataSourceConfig, boolean readonly) {
        E.unsupportedIf((null == dataSource ? 1 : 0) != 0, (String)"Hibernate require external data source provider");
        super.dataSourceProvided(dataSource, dataSourceConfig, readonly);
    }

    protected EntityManagerFactory createEntityManagerFactory(PersistenceUnitInfo persistenceUnitInfo) {
        C.Map configuration = C.Map((Object[])new Object[0]);
        return new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor(persistenceUnitInfo), (Map)configuration).build();
    }
}

