/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa;

import act.db.jpa.JPAPlugin;
import act.db.jpa.JPAService;
import act.db.jpa.sql.SqlDialect;
import act.util.DestroyableBase;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.osgl.logging.Logger;
import org.osgl.util.E;

public class JPAContext
extends DestroyableBase {
    private static final Logger LOGGER = JPAPlugin.LOGGER;
    private boolean noTx;
    private boolean rollback;
    private Map<String, Info> data = new HashMap<String, Info>();
    private TxScope txScope;
    private boolean releaseOnExitTxScope;
    private static final ThreadLocal<JPAContext> cur_ = new ThreadLocal();

    private JPAContext() {
        super(true);
    }

    private void _setNoTx() {
        this.noTx = true;
    }

    private void _setRollback() {
        this.rollback = true;
    }

    protected void releaseResources() {
        for (Info info : this.data.values()) {
            E.illegalStateIf((null != info.tx ? 1 : 0) != 0, (String)"transaction found unclosed");
            EntityManager em = info.em;
            if (null == em || !em.isOpen()) continue;
            em.close();
        }
    }

    private EntityManager _em(JPAService jpa) {
        return this.ensureInfo((JPAService)jpa).em;
    }

    private SqlDialect _dialect(JPAService jpa) {
        return this.ensureInfo((JPAService)jpa).dialect;
    }

    private Info ensureInfo(JPAService jpa) {
        Info info = this.data.get(jpa.id());
        if (null == info) {
            info = new Info(jpa);
            this.data.put(jpa.id(), info);
        }
        this.ensureTx(info);
        return info;
    }

    private void ensureTx(Info info) {
        if (this._withinTxScope() && null == info.tx) {
            info.tx = info.em.getTransaction();
            info.tx.begin();
        }
    }

    private void _enterTxScope(boolean readOnly) {
        if (!this.noTx) {
            E.illegalStateIf((boolean)this._withinTxScope(), (String)"Nested transaction not supported");
            this.txScope = new TxScope(readOnly);
        }
    }

    private boolean _withinTxScope() {
        return null != this.txScope;
    }

    private void _exitTxScope(boolean rollback) {
        if (!this.noTx) {
            E.illegalStateIfNot((boolean)this._withinTxScope(), (String)"No transaction found");
            boolean readOnly = this.txScope.readOnly;
            for (Info info : this.data.values()) {
                EntityTransaction tx = info.tx;
                if (null != tx && tx.isActive()) {
                    if (readOnly || rollback || tx.getRollbackOnly()) {
                        tx.rollback();
                    } else {
                        tx.commit();
                    }
                }
                info.tx = null;
            }
            this.txScope = null;
        }
    }

    public static boolean ready() {
        return null != cur_.get();
    }

    public static EntityManager em(JPAService jpa) {
        return JPAContext.ensureContext()._em(jpa);
    }

    public static SqlDialect dialect(JPAService jpa) {
        return JPAContext.ensureContext()._dialect(jpa);
    }

    public static void enterTxScope(boolean readOnly) {
        JPAContext ctx = JPAContext.ensureContext(true);
        ctx._enterTxScope(readOnly);
    }

    public static void beginTx(EntityManager em, JPAService jpa) {
        JPAContext ctx = JPAContext.ensureContext(true);
        ctx._enterTxScope(false);
        if (!em.isJoinedToTransaction()) {
            ctx.ensureInfo(jpa);
        }
    }

    public static void exitTxScope(boolean rollback) {
        JPAContext ctx = JPAContext.ensureContext();
        ctx._exitTxScope(rollback);
        if (ctx.releaseOnExitTxScope) {
            ctx.destroy();
            cur_.remove();
        }
    }

    public static void init() {
        E.illegalStateIf((null != cur_.get() ? 1 : 0) != 0, (String)"JPAContext already set");
        cur_.set(new JPAContext());
    }

    public static void setNoTx() {
        JPAContext ctx = JPAContext.ensureContext();
        ctx._setNoTx();
    }

    public static void setRollback() {
        JPAContext ctx = cur_.get();
        if (null != ctx) {
            ctx._setRollback();
        }
    }

    public static void close() {
        JPAContext cur = cur_.get();
        if (null != cur) {
            cur.destroy();
            cur_.remove();
        }
    }

    private static JPAContext ensureContext() {
        return JPAContext.ensureContext(false);
    }

    private static JPAContext ensureContext(boolean createIfNotAvailable) {
        JPAContext ctx = cur_.get();
        if (null == ctx) {
            E.illegalStateIf((!createIfNotAvailable ? 1 : 0) != 0, (String)"JPAContext is not ready");
            ctx = new JPAContext();
            ctx.releaseOnExitTxScope = true;
            cur_.set(ctx);
        }
        return ctx;
    }

    private static class Info {
        EntityManager em;
        EntityTransaction tx;
        SqlDialect dialect;

        Info(JPAService svc) {
            this.em = svc.createEntityManager();
            this.dialect = svc.dialect();
        }
    }

    private static class TxScope {
        boolean readOnly;

        public TxScope(boolean readOnly) {
            this.readOnly = readOnly;
        }
    }
}

