/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa;

import act.Act;
import act.db.DB;
import act.db.DaoBase;
import act.db.Model;
import act.db.jpa.JPAContext;
import act.db.jpa.JPAQuery;
import act.db.jpa.JPAService;
import act.db.jpa.sql.SQL;
import act.inject.param.NoBind;
import act.util.General;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.E;
import org.osgl.util.S;

@General
@NoBind
public class JPADao<ID_TYPE, MODEL_TYPE>
extends DaoBase<ID_TYPE, MODEL_TYPE, JPAQuery<MODEL_TYPE>> {
    private volatile JPAService _jpa;
    protected String entityName;
    protected String createdColumn;
    protected String lastModifiedColumn;
    protected String idColumn;
    protected Field idField;
    private String qIdList;

    public JPADao(Class<ID_TYPE> idType, Class<MODEL_TYPE> modelType, JPAService jpa) {
        super(idType, modelType);
        this.setJPAService(jpa);
    }

    public JPADao() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPAService jpa() {
        if (null != this._jpa) {
            return this._jpa;
        }
        JPADao jPADao = this;
        synchronized (jPADao) {
            if (null == this._jpa) {
                DB db = this.modelType().getAnnotation(DB.class);
                String dbId = null == db ? "default" : db.value();
                this._jpa = (JPAService)Act.app().dbServiceManager().dbService(dbId);
            }
        }
        return this._jpa;
    }

    public MODEL_TYPE findById(ID_TYPE id) {
        return (MODEL_TYPE)this.em().find(this.modelClass, id);
    }

    public MODEL_TYPE findLatest() {
        E.unsupportedIf((null == this.createdColumn ? 1 : 0) != 0, (String)"no CreatedAt column defined");
        return this.q().orderBy(new String[]{this.createdColumn}).first();
    }

    public MODEL_TYPE findLastModified() {
        E.unsupportedIf((null == this.lastModifiedColumn ? 1 : 0) != 0, (String)"no LastModifiedAt column defined");
        return this.q().orderBy(new String[]{this.lastModifiedColumn}).first();
    }

    public Iterable<MODEL_TYPE> findBy(String expression, Object ... values) throws IllegalArgumentException {
        return this.q(expression, values).fetch();
    }

    public MODEL_TYPE findOneBy(String expression, Object ... values) throws IllegalArgumentException {
        return this.q(expression, values).first();
    }

    public Iterable<MODEL_TYPE> findByIdList(Collection<ID_TYPE> idList) {
        return this.q(this.qIdList, new Object[]{idList}).fetch();
    }

    public MODEL_TYPE reload(MODEL_TYPE entity) {
        this.em().refresh(entity);
        return entity;
    }

    public ID_TYPE getId(MODEL_TYPE entity) {
        if (entity instanceof Model) {
            return (ID_TYPE)$.cast((Object)((Model)entity)._id());
        }
        return (ID_TYPE)(null == this.idField ? null : $.getFieldValue(entity, (Field)this.idField));
    }

    public long countBy(String expression, Object ... values) throws IllegalArgumentException {
        return this.createCountQuery(expression, values).count();
    }

    public long count() {
        return this.q(SQL.Type.COUNT).count();
    }

    public MODEL_TYPE save(MODEL_TYPE entity) {
        EntityManager em = this.em();
        if (em.isJoinedToTransaction()) {
            this._save(entity, em);
        } else {
            JPAContext.beginTx(em, this.jpa());
            try {
                this._save(entity, em);
                JPAContext.exitTxScope(false);
            }
            catch (RuntimeException e) {
                JPAContext.exitTxScope(true);
                throw e;
            }
        }
        return entity;
    }

    private void _save(MODEL_TYPE entity, EntityManager em) {
        if (!em.contains(entity)) {
            em.persist(entity);
        } else {
            em.merge(entity);
        }
    }

    public void save(MODEL_TYPE entity, String fieldList, Object ... values) {
        values = $.concat((Object[])values, this.getId(entity));
        JPAQuery<MODEL_TYPE> q = this.createUpdateQuery(fieldList, this.idColumn, values);
        EntityManager em = this.em();
        if (em.isJoinedToTransaction()) {
            q.executeUpdate();
            this.em().flush();
        } else {
            JPAContext.beginTx(em, this.jpa());
            try {
                q.executeUpdate();
                JPAContext.exitTxScope(false);
            }
            catch (RuntimeException e) {
                JPAContext.exitTxScope(true);
                throw e;
            }
        }
    }

    public List<MODEL_TYPE> save(Iterable<MODEL_TYPE> entities) {
        ArrayList list = new ArrayList();
        EntityManager em = this.em();
        if (em.isJoinedToTransaction()) {
            this._save(entities, list, em);
        } else {
            JPAContext.beginTx(em, this.jpa());
            try {
                this._save(entities, list, em);
                JPAContext.exitTxScope(false);
            }
            catch (RuntimeException e) {
                JPAContext.exitTxScope(true);
                throw e;
            }
        }
        return list;
    }

    private void _save(Iterable<MODEL_TYPE> entities, List<MODEL_TYPE> list, EntityManager em) {
        int count = 0;
        for (MODEL_TYPE entity : entities) {
            this._save(entity, em);
            if (++count % 20 == 0) {
                em.flush();
                em.clear();
            }
            list.add(entity);
        }
    }

    public void delete(MODEL_TYPE entity) {
        EntityManager em = this.em();
        if (em.isJoinedToTransaction()) {
            em.remove(entity);
            em.flush();
        } else {
            JPAContext.beginTx(em, this.jpa());
            try {
                em.remove(entity);
                JPAContext.exitTxScope(false);
            }
            catch (RuntimeException e) {
                JPAContext.exitTxScope(true);
                throw e;
            }
        }
    }

    public void delete(JPAQuery<MODEL_TYPE> query) {
        query = query.asDelete();
        EntityManager em = this.em();
        if (em.isJoinedToTransaction()) {
            query.executeUpdate();
            em.flush();
        } else {
            JPAContext.beginTx(em, this.jpa());
            try {
                query.executeUpdate();
                JPAContext.exitTxScope(false);
            }
            catch (RuntimeException e) {
                JPAContext.exitTxScope(true);
                throw e;
            }
        }
    }

    public void deleteById(ID_TYPE id) {
        this.delete(this.q(SQL.Type.DELETE, this.idColumn, id));
    }

    public void deleteBy(String expression, Object ... values) throws IllegalArgumentException {
        this.delete(this.q(SQL.Type.DELETE, expression, values));
    }

    public void deleteAll() {
        this.delete(this.q(SQL.Type.DELETE));
    }

    public void drop() {
        this.deleteAll();
    }

    public JPAQuery<MODEL_TYPE> q() {
        return this.q(SQL.Type.FIND);
    }

    public JPAQuery<MODEL_TYPE> q(SQL.Type type) {
        return this.q(type, "", new Object[0]);
    }

    public JPAQuery<MODEL_TYPE> createQuery() {
        return this.q();
    }

    public JPAQuery<MODEL_TYPE> q(String expression, Object ... values) {
        return this.q(SQL.Type.FIND, expression, values);
    }

    public JPAQuery<MODEL_TYPE> q(SQL.Type type, String expression, Object ... values) {
        E.unsupportedIf((SQL.Type.UPDATE == type ? 1 : 0) != 0, (String)"UPDATE not supported in q() API");
        JPAService jpa = this.jpa();
        JPAQuery q = new JPAQuery(jpa, this.em(jpa), this.modelClass, type, expression, new String[0]);
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            q.setParameter(i + 1, values[i]);
        }
        return q;
    }

    public JPAQuery<MODEL_TYPE> createQuery(String expression, Object ... values) {
        return this.q(expression, values);
    }

    public JPAQuery<MODEL_TYPE> createFindQuery(String expression, Object ... values) {
        return this.q(SQL.Type.FIND, expression, values);
    }

    public JPAQuery<?> createFindQuery(String fieldList, String expression, Object ... values) {
        String[] columns = fieldList.split("[,;:\\s]+");
        JPAService jpa = this.jpa();
        JPAQuery q = new JPAQuery(jpa, this.em(jpa), this.modelClass, SQL.Type.FIND, expression, columns);
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            q.setParameter(i + 1, values[i]);
        }
        return q;
    }

    public JPAQuery<MODEL_TYPE> createDeleteQuery(String expression, Object ... values) {
        return this.q(SQL.Type.DELETE, expression, values);
    }

    public JPAQuery<MODEL_TYPE> createUpdateQuery(String fieldList, String expression, Object ... values) {
        String[] columns = fieldList.split("[,;:\\s]+");
        JPAService jpa = this.jpa();
        JPAQuery q = new JPAQuery(jpa, JPAContext.em(jpa), this.modelClass, SQL.Type.UPDATE, expression, columns);
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            q.setParameter(i + 1, values[i]);
        }
        return q;
    }

    public JPAQuery<MODEL_TYPE> createCountQuery(String expression, Object ... values) {
        return this.q(SQL.Type.COUNT, expression, values);
    }

    void setJPAService(JPAService jpa) {
        Class modelType = this.modelType();
        this.entityName = jpa.entityName(modelType);
        this.createdColumn = jpa.createdColumn(modelType);
        this.lastModifiedColumn = jpa.lastModifiedColumn(modelType);
        this.idColumn = jpa.idColumn(modelType);
        this.qIdList = S.fmt((String)"%s in ", (Object[])new Object[]{this.idColumn});
        this.idField = jpa.idField(modelType);
        this._jpa = jpa;
    }

    private void apply(Osgl.Visitor<MODEL_TYPE> visitor, MODEL_TYPE entity) {
        if (null != visitor) {
            visitor.apply(entity);
        }
    }

    private EntityManager em() {
        return JPAContext.em(this.jpa());
    }

    private EntityManager em(JPAService jpa) {
        return JPAContext.em(jpa);
    }
}

