/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa;

import act.app.ActionContext;
import act.app.App;
import act.app.event.SysEvent;
import act.app.event.SysEventId;
import act.app.event.SysEventListener;
import act.db.DbPlugin;
import act.db.jpa.EntityManagerProvider;
import act.db.jpa.JPAContext;
import act.db.jpa.NamedQueryExplorer;
import act.db.jpa.NoTransaction;
import act.db.jpa.sql.Operator;
import act.db.jpa.util.TimestampAuditor;
import act.db.sql.tx.TxError;
import act.db.sql.tx.TxInfo;
import act.db.sql.tx.TxStart;
import act.db.sql.tx.TxStop;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.event.SysEventListenerBase;
import act.handler.builtin.controller.ActionHandlerInvoker;
import act.handler.builtin.controller.ExceptionInterceptor;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.handler.builtin.controller.impl.ReflectedHandlerInvoker;
import act.handler.event.PostHandle;
import act.handler.event.PreHandle;
import act.handler.event.ReflectedHandlerInvokerInit;
import act.handler.event.ReflectedHandlerInvokerInvoke;
import java.util.EventObject;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import org.osgl.inject.NamedProvider;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.mvc.result.Result;
import osgl.version.Version;
import osgl.version.Versioned;

@Versioned
public abstract class JPAPlugin
extends DbPlugin {
    public static final Logger LOGGER = LogManager.get(JPAPlugin.class);
    public static final String ATTR_NO_TRANSACTION = "no-trans";
    public static final String CONF_DDL = "jpa.ddl";
    public static final String CONF_DDL_CREATE = "create";
    public static final String CONF_DDEL_CREATE_DROP = "create-drop";
    public static final String CONF_DDL_UPDATE = "update";
    public static final String CONF_DDL_NONE = "none";
    public static final Version VERSION = Version.get();
    public static final String CONF_MAPPING_FILES = "mapping-file";

    protected void applyTo(final App app) {
        app.eventBus().bind(ReflectedHandlerInvokerInit.class, (ActEventListener)new ActEventListenerBase<ReflectedHandlerInvokerInit>(){

            public void on(ReflectedHandlerInvokerInit event) {
                ReflectedHandlerInvoker invoker = (ReflectedHandlerInvoker)event.source();
                NoTransaction noTrans = (NoTransaction)invoker.getAnnotation(NoTransaction.class);
                if (null != noTrans) {
                    invoker.attribute(JPAPlugin.ATTR_NO_TRANSACTION, (Object)noTrans);
                }
            }
        }).bind(ReflectedHandlerInvokerInvoke.class, (ActEventListener)new ActEventListenerBase<ReflectedHandlerInvokerInvoke>(){

            public void on(ReflectedHandlerInvokerInvoke event) {
                ReflectedHandlerInvoker invoker = (ReflectedHandlerInvoker)event.source();
                ActionContext context = event.context();
                Object noTrans = invoker.attribute(JPAPlugin.ATTR_NO_TRANSACTION);
                if (null != noTrans) {
                    context.attribute(JPAPlugin.ATTR_NO_TRANSACTION, noTrans);
                    JPAContext.setNoTx();
                }
            }
        }).bind(PostHandle.class, (ActEventListener)new ActEventListenerBase<PostHandle>(){

            public void on(PostHandle event) {
                JPAContext.close();
            }
        }).bind(PreHandle.class, (ActEventListener)new ActEventListenerBase(){

            public void on(EventObject event) {
                JPAContext.init();
            }
        }).bind(SysEventId.DB_SVC_LOADED, (SysEventListener)new SysEventListenerBase<SysEvent>(){

            public void on(SysEvent event) {
                new NamedQueryExplorer().explore(app);
            }
        }).bind(TxStart.class, (ActEventListener)new ActEventListenerBase<TxStart>(){

            public void on(TxStart eventObject) {
                JPAContext.enterTxScope(((TxInfo)eventObject.source()).readOnly());
            }
        }).bind(TxStop.class, (ActEventListener)new ActEventListenerBase(){

            public void on(EventObject eventObject) throws Exception {
                JPAContext.exitTxScope(false);
            }
        }).bind(TxError.class, (ActEventListener)new ActEventListenerBase(){

            public void on(EventObject eventObject) throws Exception {
                JPAContext.exitTxScope(true);
            }
        });
        app.jobManager().on(SysEventId.PRE_START, new Runnable(){

            @Override
            public void run() {
                EntityManagerProvider emp = (EntityManagerProvider)app.getInstance(EntityManagerProvider.class);
                app.injector().registerNamedProvider(EntityManager.class, (NamedProvider)emp);
                app.injector().registerProvider(EntityManager.class, (Provider)emp);
                app.getInstance(TimestampAuditor.class);
            }
        });
        RequestHandlerProxy.registerGlobalInterceptor((ExceptionInterceptor)new ExceptionInterceptor(){

            protected Result internalHandle(Exception e, ActionContext actionContext) {
                JPAContext.setRollback();
                return null;
            }

            public void accept(ActionHandlerInvoker.Visitor visitor) {
            }

            public boolean sessionFree() {
                return true;
            }

            public boolean express() {
                return true;
            }
        });
    }

    static {
        Operator.values();
    }
}

