/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa;

import act.db.Dao;
import act.db.jpa.JPAService;
import act.db.jpa.sql.SQL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NamedQuery;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.E;

public class JPAQuery<MODEL_TYPE>
implements Query,
Dao.Query<MODEL_TYPE, JPAQuery<MODEL_TYPE>> {
    private JPAService svc;
    private EntityManager em;
    private Class entityClass;
    private SQL.Type type;
    private String[] columns;
    private String expression;
    private Integer offset;
    private Integer limit;
    private String[] orderByList;
    private Map<String, Object> hints = new HashMap<String, Object>();
    private FlushModeType flushMode;
    private LockModeType lockMode;
    private Query q;
    private Map<Integer, Object> params = new HashMap<Integer, Object>();
    private Map<Integer, Osgl.T2<Calendar, TemporalType>> calendarParams = new HashMap<Integer, Osgl.T2<Calendar, TemporalType>>();
    private Map<Integer, Osgl.T2<Date, TemporalType>> dateParams = new HashMap<Integer, Osgl.T2<Date, TemporalType>>();

    public JPAQuery(JPAService svc, EntityManager em, Class entityClass, SQL.Type type, String expression, String ... columns) {
        this.svc = (JPAService)((Object)$.notNull((Object)((Object)svc)));
        this.em = (EntityManager)$.notNull((Object)em);
        this.entityClass = (Class)$.notNull((Object)entityClass);
        this.type = (SQL.Type)((Object)$.notNull((Object)((Object)type)));
        this.expression = (String)$.notNull((Object)expression);
        this.columns = columns;
    }

    private JPAQuery(JPAQuery copy) {
        this.svc = copy.svc;
        this.em = copy.em;
        this.entityClass = copy.entityClass;
        this.type = copy.type;
        this.expression = copy.expression;
        this.columns = copy.columns;
        this.offset = copy.offset;
        this.limit = copy.limit;
        this.orderByList = copy.orderByList;
        this.hints = copy.hints;
        this.flushMode = copy.flushMode;
        this.lockMode = copy.lockMode;
    }

    public JPAQuery<MODEL_TYPE> asFind() {
        return this.as(SQL.Type.FIND);
    }

    public JPAQuery<MODEL_TYPE> asDelete() {
        return this.as(SQL.Type.DELETE);
    }

    public JPAQuery<MODEL_TYPE> asUpdate() {
        if (SQL.Type.UPDATE == this.type) {
            return this;
        }
        throw E.unsupport((String)"Cannot convert other query types to UPDATE", (Object[])new Object[0]);
    }

    public JPAQuery<MODEL_TYPE> asCount() {
        return this.as(SQL.Type.COUNT);
    }

    public JPAQuery<MODEL_TYPE> as(SQL.Type type) {
        if (type == this.type) {
            return this;
        }
        JPAQuery<MODEL_TYPE> copy = new JPAQuery<MODEL_TYPE>(this);
        copy.type = type;
        return copy;
    }

    public JPAQuery<MODEL_TYPE> offset(int pos) {
        E.illegalArgumentIf((pos < 0 ? 1 : 0) != 0, (String)("Invalid offset position: " + pos));
        this.offset = pos;
        if (null != this.q) {
            this.q.setFirstResult(pos);
        }
        return this;
    }

    public JPAQuery<MODEL_TYPE> limit(int limit) {
        E.illegalArgumentIf((limit < 1 ? 1 : 0) != 0, (String)("Invalid limit size: " + limit));
        this.limit = limit;
        if (null != this.q) {
            this.q.setMaxResults(limit);
        }
        return this;
    }

    public JPAQuery<MODEL_TYPE> orderBy(String ... fieldList) {
        if (null != this.q) {
            JPAQuery<MODEL_TYPE> newQuery = new JPAQuery<MODEL_TYPE>(this);
            newQuery.orderByList = fieldList;
            return newQuery;
        }
        this.orderByList = fieldList;
        return this;
    }

    public MODEL_TYPE first() {
        return (MODEL_TYPE)$.cast((Object)this.q().getSingleResult());
    }

    public List<MODEL_TYPE> fetch() {
        return (List)$.cast((Object)this.q().getResultList());
    }

    public long count() {
        if (this.type != SQL.Type.COUNT) {
            return this.asCount().count();
        }
        Number n = (Number)this.q().getSingleResult();
        return n.longValue();
    }

    public List getResultList() {
        return this.q().getResultList();
    }

    public Object getSingleResult() {
        return this.q().getSingleResult();
    }

    public int executeUpdate() {
        return this.q().executeUpdate();
    }

    public Query setMaxResults(int maxResult) {
        return this.limit(maxResult);
    }

    public int getMaxResults() {
        return this.limit;
    }

    public Query setFirstResult(int startPosition) {
        return this.offset(startPosition);
    }

    public int getFirstResult() {
        return this.offset;
    }

    public Query setHint(String hintName, Object value) {
        this.hints.put(hintName, value);
        if (null != this.q) {
            this.q.setHint(hintName, value);
        }
        return this;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    public <T> Query setParameter(Parameter<T> param, T value) {
        this.q().setParameter(param, value);
        return this;
    }

    public Query setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.q().setParameter(param, value, temporalType);
        return this;
    }

    public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.q().setParameter(param, value, temporalType);
        return this;
    }

    public Query setParameter(String name, Object value) {
        this.q().setParameter(name, value);
        return this;
    }

    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        this.q().setParameter(name, value, temporalType);
        return this;
    }

    public Query setParameter(String name, Date value, TemporalType temporalType) {
        this.q().setParameter(name, value, temporalType);
        return this;
    }

    public Query setParameter(int position, Object value) {
        if (null != this.q) {
            this.q.setParameter(position, value);
        }
        this.params.put(position, value);
        return this;
    }

    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        if (null != this.q) {
            this.q.setParameter(position, value, temporalType);
        }
        this.calendarParams.put(position, (Osgl.T2<Calendar, TemporalType>)$.T2((Object)value, (Object)temporalType));
        return this;
    }

    public Query setParameter(int position, Date value, TemporalType temporalType) {
        if (null != this.q) {
            this.q.setParameter(position, value, temporalType);
        }
        this.dateParams.put(position, (Osgl.T2<Date, TemporalType>)$.T2((Object)value, (Object)temporalType));
        return this;
    }

    public Set<Parameter<?>> getParameters() {
        return this.q().getParameters();
    }

    public Parameter<?> getParameter(String name) {
        return this.q().getParameter(name);
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return this.q().getParameter(name, type);
    }

    public Parameter<?> getParameter(int position) {
        return this.q().getParameter(position);
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return this.q().getParameter(position, type);
    }

    public boolean isBound(Parameter<?> param) {
        return this.q().isBound(param);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return (T)this.q().getParameterValue(param);
    }

    public Object getParameterValue(String name) {
        return this.q().getParameterValue(name);
    }

    public Object getParameterValue(int position) {
        return this.q().getParameterValue(position);
    }

    public Query setFlushMode(FlushModeType flushMode) {
        this.flushMode = (FlushModeType)$.notNull((Object)flushMode);
        if (null != this.q) {
            this.q.setFlushMode(flushMode);
        }
        return this;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public Query setLockMode(LockModeType lockMode) {
        this.lockMode = (LockModeType)$.notNull((Object)lockMode);
        if (null != this.q) {
            this.q.setLockMode(lockMode);
        }
        return this;
    }

    public LockModeType getLockMode() {
        return this.lockMode;
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.q().unwrap(cls);
    }

    private Query q() {
        if (null == this.q) {
            Osgl.T2 t2;
            NamedQuery nq = this.svc.namedQuery(this.expression);
            this.q = null != nq ? this.em.createNamedQuery(this.expression) : this.em.createQuery(this.svc.getSQL(this.type, this.entityClass, this.expression, this.columns).withOrderBy(this.orderByList).rawSql(this.svc.dialect()));
            if (null != this.lockMode) {
                this.q.setLockMode(this.lockMode);
            }
            if (null != this.flushMode) {
                this.q.setFlushMode(this.flushMode);
            }
            for (Map.Entry<Integer, Object> entry : this.params.entrySet()) {
                this.q.setParameter(entry.getKey().intValue(), entry.getValue());
            }
            for (Map.Entry<Integer, Object> entry : this.calendarParams.entrySet()) {
                t2 = (Osgl.T2)entry.getValue();
                this.q.setParameter(entry.getKey().intValue(), (Calendar)t2._1, (TemporalType)t2._2);
            }
            for (Map.Entry<Integer, Object> entry : this.dateParams.entrySet()) {
                t2 = (Osgl.T2)entry.getValue();
                this.q.setParameter(entry.getKey().intValue(), (Date)t2._1, (TemporalType)t2._2);
            }
            for (Map.Entry<Object, Object> entry : this.hints.entrySet()) {
                this.q.setHint((String)entry.getKey(), entry.getValue());
            }
        }
        return this.q;
    }
}

