/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa;

import act.Act;
import act.app.App;
import act.db.DB;
import act.db.Dao;
import act.db.DbService;
import act.db.jpa.JPADao;
import act.db.jpa.PersistenceUnitInfoImpl;
import act.db.jpa.sql.DefaultSqlDialect;
import act.db.jpa.sql.SQL;
import act.db.jpa.sql.SqlDialect;
import act.db.meta.EntityClassMetaInfo;
import act.db.meta.EntityFieldMetaInfo;
import act.db.meta.EntityMetaInfoRepo;
import act.db.sql.DataSourceConfig;
import act.db.sql.SqlDbService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.E;

public abstract class JPAService
extends SqlDbService {
    protected EntityMetaInfoRepo entityMetaInfoRepo;
    protected ConcurrentMap<SQLKey, SQL> sqlCache = new ConcurrentHashMap<SQLKey, SQL>();
    private Map<String, NamedQuery> namedQueries = new HashMap<String, NamedQuery>();
    EntityManagerFactory emFactory;

    public JPAService(String dbId, App app, Map<String, String> config) {
        super(dbId, app, config);
    }

    protected void dataSourceProvided(DataSource dataSource, DataSourceConfig dataSourceConfig) {
        super.dataSourceProvided(dataSource, dataSourceConfig);
        String dbId = this.id();
        this.entityMetaInfoRepo = this.app().entityMetaInfoRepo().forDb(dbId);
        this.emFactory = this.createEntityManagerFactory(dbId, dataSource);
    }

    protected DataSource createDataSource() {
        throw E.unsupport();
    }

    protected boolean supportDdl() {
        return true;
    }

    public <DAO extends Dao> DAO defaultDao(Class<?> modelType) {
        Class idType = JPAService.findModelIdTypeByAnnotation(modelType, Id.class);
        E.illegalArgumentIf((null == idType ? 1 : 0) != 0, (String)"Cannot find out Dao for model type[%s]: unable to identify the ID type", (Object[])new Object[]{modelType});
        return (DAO)((Object)this.newDao(idType, modelType));
    }

    public <DAO extends Dao> DAO newDaoInstance(Class<DAO> aClass) {
        E.illegalArgumentIfNot((boolean)this.isValidDaoClass(aClass), (String)"The class is not a JPA Dao: %s", (Object[])new Object[]{aClass});
        JPADao dao = (JPADao)((Object)$.cast((Object)this.app().getInstance(aClass)));
        dao.setJPAService(this);
        return (DAO)((Dao)$.cast((Object)((Object)dao)));
    }

    public Class<? extends Annotation> entityAnnotationType() {
        return Entity.class;
    }

    public SQL getSQL(SQL.Type type, Class entityClass, String expression, String ... columns) {
        SQLKey key = new SQLKey(type, entityClass, expression, columns);
        SQL sql = (SQL)this.sqlCache.get(key);
        if (null == sql) {
            String entityName = this.entityName(entityClass);
            E.illegalArgumentIf((null == entityName ? 1 : 0) != 0, (String)("cannot find entity name for " + entityClass));
            sql = SQL.Parser.parse(type, entityName, expression, columns);
            this.sqlCache.putIfAbsent(key, sql);
        }
        return sql;
    }

    protected <ID_TYPE, MODEL_TYPE> JPADao<ID_TYPE, MODEL_TYPE> newDao(Class<ID_TYPE> idType, Class<MODEL_TYPE> modelType) {
        return new JPADao<ID_TYPE, MODEL_TYPE>(idType, modelType, this);
    }

    protected Class<? extends JPADao> baseDaoClass() {
        return JPADao.class;
    }

    protected abstract Class<? extends PersistenceProvider> persistenceProviderClass();

    protected abstract EntityManagerFactory createEntityManagerFactory(PersistenceUnitInfo var1);

    protected <DAO extends Dao> boolean isValidDaoClass(Class<DAO> aClass) {
        return this.baseDaoClass().isAssignableFrom(aClass);
    }

    protected Properties processProperties(Properties properties) {
        return properties;
    }

    protected void registerNamedQuery(NamedQuery nq) {
        this.namedQueries.put(nq.name(), nq);
    }

    protected NamedQuery namedQuery(String name) {
        return this.namedQueries.get(name);
    }

    String lastModifiedColumn(Class<?> modelClass) {
        EntityFieldMetaInfo fieldInfo = this.classInfo(modelClass).lastModifiedAtField();
        return null == fieldInfo ? null : fieldInfo.columnName();
    }

    String createdColumn(Class<?> modelClass) {
        EntityFieldMetaInfo fieldInfo = this.classInfo(modelClass).createdAtField();
        return null == fieldInfo ? null : fieldInfo.columnName();
    }

    String idColumn(Class<?> modelClass) {
        EntityFieldMetaInfo fieldInfo = this.classInfo(modelClass).idField();
        return null == fieldInfo ? null : fieldInfo.columnName();
    }

    Field idField(Class<?> modelClass) {
        EntityFieldMetaInfo fieldInfo = this.classInfo(modelClass).idField();
        return null == fieldInfo ? null : $.fieldOf(modelClass, (String)fieldInfo.fieldName());
    }

    String columnName(Field field) {
        return this.classInfo(field.getDeclaringClass()).fieldInfo(field.getName()).columnName();
    }

    String entityName(Class<?> modelClass) {
        return this.classInfo(modelClass).entityName();
    }

    SqlDialect dialect() {
        return DefaultSqlDialect.INSTANCE;
    }

    EntityManager createEntityManager() {
        return this.emFactory.createEntityManager();
    }

    private EntityClassMetaInfo classInfo(Class<?> modelClass) {
        return this.entityMetaInfoRepo.classMetaInfo(modelClass);
    }

    private EntityManagerFactory createEntityManagerFactory(String dbName, DataSource dataSource) {
        PersistenceUnitInfoImpl persistenceUnitInfo = this.persistenceUnitInfo(dbName);
        persistenceUnitInfo.setNonJtaDataSource(dataSource);
        return this.createEntityManagerFactory(persistenceUnitInfo);
    }

    private PersistenceUnitInfoImpl persistenceUnitInfo(String dbName) {
        Properties properties = this.properties();
        properties = this.processProperties(properties);
        C.List managedClasses = C.list((Collection)this.entityMetaInfoRepo.entityClasses());
        return this.persistenceUnitInfo(this.persistenceProviderClass().getName(), dbName, (List<Class>)managedClasses, this.mappingFiles(), properties);
    }

    private Properties properties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.config.rawConf);
        properties.put("javax.persistence.transaction", "RESOURCE_LOCAL");
        return properties;
    }

    private List<String> mappingFiles() {
        String mappingFiles = (String)this.config.rawConf.get("mapping-file");
        return null == mappingFiles ? C.list() : C.list((Object)mappingFiles);
    }

    private PersistenceUnitInfoImpl persistenceUnitInfo(String persistenceProviderClass, String persistenceUnitName, List<Class> managedClasses, List<String> mappingFileNames, Properties properties) {
        return new PersistenceUnitInfoImpl(persistenceProviderClass, persistenceUnitName, managedClasses, mappingFileNames, properties, (ClassLoader)this.app().classLoader());
    }

    private void postDaoConstructor(JPADao dao) {
        E.tbd((String)"Set JPA context to dao");
    }

    public static JPAService findByModelClass(Class<?> modelClass) {
        DB db = modelClass.getAnnotation(DB.class);
        String serviceId = null == db ? "default" : db.value();
        DbService service = Act.app().dbServiceManager().dbService(serviceId);
        return service instanceof JPAService ? (JPAService)service : null;
    }

    private static class SQLKey {
        private Class entityClass;
        private String expression;
        private SQL.Type type;
        private List<String> columns;

        public SQLKey(SQL.Type type, Class entityClass, String expression, String ... columns) {
            this.entityClass = entityClass;
            this.expression = expression;
            this.type = type;
            this.columns = C.listOf((Object[])columns);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SQLKey sqlKey = (SQLKey)o;
            return this.type == sqlKey.type && $.eq((Object)this.expression, (Object)sqlKey.expression) && $.eq(this.columns, sqlKey.columns) && $.eq((Object)this.entityClass, (Object)sqlKey.entityClass);
        }

        public int hashCode() {
            return $.hc((Object)this.entityClass, (Object)this.expression, (Object)((Object)this.type), this.columns);
        }
    }
}

