/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa;

import act.app.App;
import act.app.DbServiceManager;
import act.db.DbService;
import act.db.jpa.JPAService;
import act.db.meta.EntityMetaInfoRepo;
import act.db.meta.MasterEntityMetaInfoRepo;
import java.util.Set;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;

class NamedQueryExplorer {
    NamedQueryExplorer() {
    }

    void explore(App app) {
        DbServiceManager mgr = app.dbServiceManager();
        MasterEntityMetaInfoRepo repo = app.entityMetaInfoRepo();
        for (DbService svc : mgr.registeredServices()) {
            String dbId = svc.id();
            EntityMetaInfoRepo repo0 = repo.forDb(dbId);
            if (null == repo0 || !(svc instanceof JPAService)) continue;
            this.lookupIn((JPAService)svc, repo0);
        }
    }

    private void lookupIn(JPAService svc, EntityMetaInfoRepo repo) {
        Set managedClasses = repo.entityClasses();
        for (Class c : managedClasses) {
            this.lookupIn(c, svc);
        }
    }

    private void lookupIn(Class<?> entityClass, JPAService svc) {
        NamedQueries namedQueries;
        if (null == entityClass || Object.class == entityClass) {
            return;
        }
        NamedQuery namedQuery = entityClass.getAnnotation(NamedQuery.class);
        if (null != namedQuery) {
            svc.registerNamedQuery(namedQuery);
        }
        if (null != (namedQueries = entityClass.getAnnotation(NamedQueries.class))) {
            for (NamedQuery nq : namedQueries.value()) {
                svc.registerNamedQuery(nq);
            }
        }
        this.lookupIn(entityClass.getSuperclass(), svc);
    }
}

