/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.E;

public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private final String persistenceUnitName;
    private final String persistenceProviderClass;
    private final List<Class> managedClasses;
    private final List<String> mappingFileNames;
    private final Properties properties;
    private final ClassLoader classLoader;
    private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;

    public PersistenceUnitInfoImpl(String persistenceProviderClass, String persistenceUnitName, List<Class> managedClasses, List<String> mappingFileNames, Properties properties, ClassLoader classLoader) {
        this.persistenceProviderClass = persistenceProviderClass;
        this.persistenceUnitName = persistenceUnitName;
        this.managedClasses = managedClasses;
        this.mappingFileNames = mappingFileNames;
        this.properties = properties;
        this.classLoader = (ClassLoader)$.notNull((Object)classLoader);
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClass;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public PersistenceUnitInfoImpl setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
        this.nonJtaDataSource = null;
        this.transactionType = PersistenceUnitTransactionType.JTA;
        return this;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public PersistenceUnitInfoImpl setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
        this.jtaDataSource = null;
        this.transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        return this;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public List<URL> getJarFileUrls() {
        return Collections.emptyList();
    }

    public URL getPersistenceUnitRootUrl() {
        try {
            return new File(".").toURI().toURL();
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    public List<String> getManagedClassNames() {
        return C.list(this.managedClasses).map((Osgl.Function)new Osgl.Transformer<Class, String>(){

            public String transform(Class aClass) {
                return aClass.getName();
            }
        });
    }

    public boolean excludeUnlistedClasses() {
        return false;
    }

    public SharedCacheMode getSharedCacheMode() {
        return SharedCacheMode.UNSPECIFIED;
    }

    public ValidationMode getValidationMode() {
        return ValidationMode.AUTO;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPersistenceXMLSchemaVersion() {
        return "2.2";
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addTransformer(ClassTransformer transformer) {
    }

    public ClassLoader getNewTempClassLoader() {
        return null;
    }

    public static void main(String[] args) throws Exception {
        new URL("file:/jpa-common");
    }
}

