/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa;

import act.app.App;
import act.asm.AnnotationVisitor;
import act.asm.Type;
import act.db.meta.EntityClassMetaInfo;
import act.db.meta.EntityFieldMetaInfo;
import act.db.meta.EntityMetaInfoRepo;
import act.util.AppByteCodeEnhancer;
import org.osgl.util.S;

public class TimestampAuditorEnhancer
extends AppByteCodeEnhancer<TimestampAuditorEnhancer> {
    private EntityMetaInfoRepo metaInfoRepo;
    private String className;
    private EntityFieldMetaInfo createdAt;
    private EntityFieldMetaInfo lastModifiedAt;
    private boolean entityListenersFound;

    public TimestampAuditorEnhancer() {
        super(S.F.startsWith((String)"act.").negate());
    }

    public AppByteCodeEnhancer app(App app) {
        this.metaInfoRepo = app.entityMetaInfoRepo();
        return super.app(app);
    }

    protected Class<TimestampAuditorEnhancer> subClass() {
        return TimestampAuditorEnhancer.class;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String classDesc = "L" + name + ";";
        this.className = Type.getType((String)classDesc).getClassName();
        EntityClassMetaInfo classMetaInfo = this.metaInfoRepo.classMetaInfo(this.className);
        if (null != classMetaInfo) {
            this.createdAt = classMetaInfo.createdAtField();
            this.lastModifiedAt = classMetaInfo.lastModifiedAtField();
            this.entityListenersFound = classMetaInfo.hasEntityListeners();
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        if (!(this.entityListenersFound || null == this.createdAt && null == this.lastModifiedAt)) {
            AnnotationVisitor av = super.visitAnnotation("Ljavax/persistence/EntityListeners;", true);
            AnnotationVisitor av1 = av.visitArray("value");
            av1.visit(null, (Object)Type.getType((String)"Lact/db/jpa/util/TimestampAuditor;"));
            av1.visitEnd();
            av.visitEnd();
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if ((null != this.createdAt || null != this.lastModifiedAt) && this.entityListenersFound && "Ljavax/persistence/EntityListeners;".equals(desc)) {
            return new AnnotationVisitor(327680, av){

                public AnnotationVisitor visitArray(String name) {
                    return new AnnotationVisitor(327680, super.visitArray(name)){

                        public void visitEnd() {
                            this.visit(null, Type.getType((String)"Lact/db/jpa/util/TimestampAuditor;"));
                            super.visitEnd();
                        }
                    };
                }
            };
        }
        return av;
    }
}

