/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa.sql;

import act.db.jpa.sql.SqlDialect;
import act.db.jpa.sql.SqlPart;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public abstract class Action
implements SqlPart {
    protected final String fromTarget;
    protected final String entityShort;
    protected final String entityShortPrefix;

    public Action(String entityName) {
        String alias = SqlPart.Util.entityAlias(entityName);
        this.entityShort = S.wrap((String)alias, (char)' ');
        this.entityShortPrefix = S.concat((String)" ", (String)alias, (String)".");
        this.fromTarget = S.concat((String)entityName, (String)this.entityShort);
    }

    public static class Update
    extends Action {
        private List<String> columns;

        public Update(String entityName, List<String> columns) {
            super(entityName);
            E.illegalArgumentIf((boolean)columns.isEmpty(), (String)"columns expected for Update action");
            this.columns = (List)$.notNull(columns);
        }

        public Update(String entityName, String ... columns) {
            super(entityName);
            E.illegalArgumentIf((0 == columns.length ? 1 : 0) != 0, (String)"columns expected for Update action");
            this.columns = C.listOf((Object[])columns);
        }

        @Override
        public void print(SqlDialect dialect, StringBuilder builder, AtomicInteger paramId, String entityAliasPrefix) {
            builder.append("UPDATE ").append(this.fromTarget);
            for (String column : this.columns) {
                builder.append(" SET ").append(this.entityShortPrefix).append(column).append(" = ?").append(paramId.incrementAndGet());
            }
        }
    }

    public static class Count
    extends Action {
        public Count(String entityName) {
            super(entityName);
        }

        @Override
        public void print(SqlDialect dialect, StringBuilder builder, AtomicInteger paramId, String entityAliasPrefix) {
            builder.append("SELECT COUNT(").append(this.entityShort).append(") FROM ").append(this.fromTarget);
        }
    }

    public static class Delete
    extends Action {
        public Delete(String entityName) {
            super(entityName);
        }

        @Override
        public void print(SqlDialect dialect, StringBuilder builder, AtomicInteger paramId, String entityAliasPrefix) {
            builder.append("DELETE FROM ").append(this.fromTarget);
        }
    }

    public static class Select
    extends Action {
        private List<String> columns;

        public Select(String entityName, List<String> columns) {
            super(entityName);
            this.columns = (List)$.notNull(columns);
        }

        public Select(String entityName, String ... columns) {
            super(entityName);
            this.columns = C.listOf((Object[])columns);
        }

        @Override
        public void print(SqlDialect dialect, StringBuilder builder, AtomicInteger paramId, String entityAliasPrefix) {
            int len = this.columns.size();
            if (0 == len) {
                builder.append("SELECT").append(this.entityShort).append("FROM ").append(this.fromTarget);
            } else {
                builder.append("SELECT").append(this.entityShortPrefix).append(this.columns.get(0));
                for (int i = 1; i < len; ++i) {
                    builder.append(",").append(this.entityShortPrefix).append(this.columns.get(i));
                }
                builder.append(" FROM ").append(this.fromTarget);
            }
        }
    }
}

